<?php

namespace Misterllantas\Buscadorllantas\Controller\Index;

use Magento\Framework\App\Action\Action;
use Magento\Framework\App\Action\Context;
use Magento\Framework\App\ResponseInterface;
use Magento\Framework\Controller\ResultInterface;
use Magento\Framework\Exception\NotFoundException;
use Magento\Framework\Controller\Result\JsonFactory;
use Magento\Framework\App\ObjectManager;

class Index extends Action
{
    /**
     * @var PageFactory
     */
    private $resultJsonFactory;

    /**
     * Index constructor.
     * @param Context $context
     * @param resultJsonFactory $resultJsonFactory
     */
    public function __construct(
        Context $context,
        JsonFactory $resultJsonFactory
    ) {
        parent::__construct($context);
        $this->resultJsonFactory = $resultJsonFactory;
    }


    /**
     * Execute action based on request and return result
     *
     * Note: Request will be added as operation argument in future
     *
     * @return ResultInterface|ResponseInterface
     * @throws NotFoundException
     */
    public function execute()
    {
        /** @var \Magento\Framework\Controller\Result\Json $result */

        $result = $this->resultJsonFactory->create();
        $collections = $this->getVendorCar();
        if (!empty($collections) && count($collections) > 0) {
            return $result->setData([
                'success' => true,
                'result' => $collections
            ]);
        } else {
            return $result->setData([
                'success' => false,
                'result' => 'null'
            ]);
        }
    }

    public function getVendorCar()
    {
        $objectManager = ObjectManager::getInstance();
        $collection = $objectManager->create('Misterllantas\Buscadorllantas\Model\ResourceModel\Car\Collection');
        $collection->getSelect()
            ->distinct(true)
            ->reset(\Zend_Db_Select::COLUMNS)
            ->columns(['vendor'])
            ->group('vendor');
        return $collection->toArray();
    }
}
