<?php

namespace Misterllantas\Buscadorllantas\Controller\Index;

use Magento\Framework\App\Action\Action;
use Magento\Framework\App\Action\Context;
use Magento\Framework\Controller\ResultFactory;

class Resultado extends Action
{
    protected $resultJsonFactory;

    public function __construct(
        ResultFactory $resultJsonFactory,
        Context $context
    ) {
        parent::__construct($context);
        $this->resultJsonFactory = $resultJsonFactory;
    }

    public function execute()
    {
        $action = $this->getRequest()->getParam('action');
        if (!empty($action)) {
            switch ($action) {
                case 'PorVehiculo':
                    $vendor = $this->getRequest()->getParam('vendor');
                    $car = $this->getRequest()->getParam('car');
                    $year = $this->getRequest()->getParam('year');
                    $modification = $this->getRequest()->getParam('modification');

                    if (!empty($vendor) && !empty($car) && !empty($year) && !empty($modification)) {
                        $url = strtolower($vendor . '/' . $car . '/' . $year . '/' . $modification);

                        $response = [
                            'success' => true,
                            'message' => 'Successfull',
                            'redirectUrl' => "llantas-para/" . $url . '/',
                        ];
                    } else {
                        $response = [
                            'success' => false,
                            'message' => 'fail',
                            'redirectUrl' => '/'
                        ];
                    }
                    /** @var \Magento\Framework\Controller\Result\Json $resultJson */
                    $resultJson = $this->resultJsonFactory->create(ResultFactory::TYPE_JSON);
                    $resultJson->setData($response);
                    return $resultJson;
                    break;

                case 'PorMedida':
                    $ancho = $this->getRequest()->getParam('ancho');
                    $alto = $this->getRequest()->getParam('alto');
                    $rin  = $this->getRequest()->getParam('rin');

                    if (!empty($ancho) && !empty($alto) && !empty($rin)) {
                        if ($alto == '-') {
                            $alto = '_';
                        }
                        $modification = strtolower($ancho . '-' . $alto . '-' . $rin ); //. '.html'
                        $response = [
                            'success' => true,
                            'message' => 'Successfull',
                            'redirectUrl' => $modification,
                        ];
                    } else {
                        $response = [
                            'success' => false,
                            'message' => 'fail',
                            'redirectUrl' => '/'
                        ];
                    }
                    /** @var \Magento\Framework\Controller\Result\Json $resultJson */
                    $resultJson = $this->resultJsonFactory->create(ResultFactory::TYPE_JSON);
                    $resultJson->setData($response);
                    return $resultJson;

                    break;
                default:
                    return null;
                    break;
            }
        }
    }
}
