<?php

namespace Misterllantas\Buscadorllantas\Controller\Index;

use Magento\Framework\App\Action\Action;
use Magento\Framework\App\Action\Context;
use Magento\Framework\Controller\Result\JsonFactory;

class Rin extends Action
{
    private $resultJsonFactory;
    private $_productCollectionFactory;
    private $eavConfig;
    protected $productVisibility;
    protected $productStatus;

    public function __construct(
        \Magento\Catalog\Model\ResourceModel\Product\CollectionFactory $productCollectionFactory,
        \Magento\Catalog\Model\Product\Visibility $productVisibility,
        \Magento\Catalog\Model\Product\Attribute\Source\Status $productStatus,
        \Magento\Eav\Model\Config $eavConfig,
        JsonFactory $resultJsonFactory,
        Context $context
    ) {
        parent::__construct($context);
        $this->resultJsonFactory = $resultJsonFactory;
        $this->_productCollectionFactory = $productCollectionFactory;
        $this->context = $context;
        $this->eavConfig = $eavConfig;
        $this->productVisibility = $productVisibility;
        $this->productStatus = $productStatus;
    }

    public function execute()
    {
        $result = $this->resultJsonFactory->create();
        $collections = $this->getRinFuxz();

        if (!empty($collections)) {
            return $result->setData([
                'success' => true,
                'result' => $collections
            ]);
        } else {
            return $result->setData([
                'success' => false,
                'result' => 'null'
            ]);
        }
    }

    public function getRinFuxz(){

        $collection = [];

        $ancho = $this->getRequest()->getParam('ancho');
        $alto = $this->getRequest()->getParam('alto');

        $ancho_attr = $this->eavConfig->getAttribute('catalog_product', 'ancho');
        $alto_attr = $this->eavConfig->getAttribute('catalog_product', 'alto');

        $_anchos = $ancho_attr->getSource()->getAllOptions();
        $_altos = $alto_attr->getSource()->getAllOptions();
        
        	$ancho_value = '';
        	$ancho_label = '';
        	$alto_value = '';
        	$alto_label = '';
        	
        foreach ($_anchos as $key => $value) {
	        if ($value['label'] == $ancho) {
	            $ancho_value = $value['value'];
	            $ancho_label = $value['label'];
	            //array_push($collection, $ancho_label);
	        }
        }
        
        foreach ($_altos as $key1 => $value_alt) {
	        if ($value_alt['label'] == $alto) {
	            $alto_value = $value_alt['value'];
	            $alto_label = $value_alt['label'];
	            //array_push($collection, $alto_label);
	        }
        }

        $_productCollection = $this->_productCollectionFactory->create();
        $_productCollection->addAttributeToSelect('rin');
        $_productCollection->distinct(true);
        $_productCollection->addAttributeToFilter('ancho', array('eq' => $ancho_value));
        $_productCollection->addAttributeToFilter('alto', array('eq' => $alto_value));
        $_productCollection->addAttributeToFilter('status', ['in' => $this->productStatus->getVisibleStatusIds()]);
        $_productCollection->setVisibility($this->productVisibility->getVisibleInSiteIds());
        $_productCollection->setOrder('rin', 'ASC');
        $_productCollection->getSelect()->group('rin');

        foreach ($_productCollection as $product) {
        	$super_rin = $product->getResource()->getAttribute('rin')->getFrontend()->getValue($product);

            array_push($collection, $super_rin);
        }

        return $collection;
    }

}