<?php

namespace Misterllantas\Buscadorllantas\Controller\Index;

use Magento\Framework\App\Action\Action;
use Magento\Framework\App\Action\Context;
use Magento\Framework\Controller\Result\JsonFactory;

class Rin extends Action
{
    private $resultJsonFactory;
    private $_productCollectionFactory;
    private $eavConfig;
    protected $productVisibility;
    protected $productStatus;

    public function __construct(
        \Magento\Catalog\Model\ResourceModel\Product\CollectionFactory $productCollectionFactory,
        \Magento\Catalog\Model\Product\Visibility $productVisibility,
        \Magento\Catalog\Model\Product\Attribute\Source\Status $productStatus,
        \Magento\Eav\Model\Config $eavConfig,
        JsonFactory $resultJsonFactory,
        Context $context
    ) {
        parent::__construct($context);
        $this->resultJsonFactory = $resultJsonFactory;
        $this->_productCollectionFactory = $productCollectionFactory;
        $this->context = $context;
        $this->eavConfig = $eavConfig;
        $this->productVisibility = $productVisibility;
        $this->productStatus = $productStatus;
    }

    public function execute()
    {
        $result = $this->resultJsonFactory->create();
        $collections = $this->processRinLlanta();
        if (!empty($collections)) {
            return $result->setData([
                'success' => true,
                'result' => $collections
            ]);
        } else {
            return $result->setData([
                'success' => false,
                'result' => 'null'
            ]);
        }
    }
    public function processRinLlanta()
    {
        $resultAtributeAlto = [];
        $alto = $this->getRequest()->getParam('alto');

        if (isset($alto) && !empty($alto)) {
            $atribute_alto = $this->getAltoAtribute($alto);
            $arrayAtributeRin = $this->getRinAtributeCollection($atribute_alto);
            $arrayAtributeRin = array_unique($arrayAtributeRin);
       
            foreach ($arrayAtributeRin as $item) {
                array_push($resultAtributeAlto, $this->getRinAtribute($item));
            }
            sort($resultAtributeAlto);
            return $resultAtributeAlto;
        }
    }

    public function getAltoAtribute($alto)
    {
        $attribute = $this->eavConfig->getAttribute('catalog_product', 'alto');
        $_options = $attribute->getSource()->getAllOptions();

        foreach ($_options as $key => $value) {
            if ($value['label'] === $alto) {
                $alto_value = $value['value'];
            }
            continue;
        }
        if (!empty($alto_value)) {
            return $alto_value;
        } else {
            return $alto_value = null;
        }
    }

    public function getRinAtributeCollection($alto_value)
    {
        $collection = [];
        $_productCollection = $this->_productCollectionFactory->create();
        $_productCollection->addAttributeToSelect('rin');
        $_productCollection->distinct(true);
        $_productCollection->addAttributeToFilter('alto', array('eq' =>  $alto_value));
        $_productCollection->addAttributeToFilter('status', ['in' => $this->productStatus->getVisibleStatusIds()]);
        $_productCollection->setVisibility($this->productVisibility->getVisibleInSiteIds());
        $_productCollection->setOrder('entity_id', 'DESC');
        $_productCollection->groupByAttribute('rin');
        /* echo $_productCollection->getSelect()->__toString();
        die;  */

        foreach ($_productCollection as $product) {
            array_push($collection, $product->getRin());
        }
        return $collection;
    }

    public function getRinAtribute($alto)
    {
        $resultArray = [];
        $attribute = $this->eavConfig->getAttribute('catalog_product', 'rin');
        $_options = $attribute->getSource()->getAllOptions();

        foreach ($_options as $key => $value) {
            if ($value['value'] === $alto) {
                array_push($resultArray, $value['label']);
            }
            continue;
        }
        return $resultArray;
    }
}
