<?php

namespace Misterllantas\Buscadorllantas\Controller;

use Magento\Framework\App\ActionFactory;
use Magento\Framework\App\RouterInterface;
use Magento\Framework\App\RequestInterface;

class Router implements RouterInterface
{
    private $actionFactory;

    /**
     * Router constructor.
     * @param \Magento\Framework\App\ActionFactory $actionFactory
     */

    public function __construct(ActionFactory $actionFactory)
    {
        $this->actionFactory = $actionFactory;
    }

    /**
     * @param \Magento\Framework\App\RequestInterface $request
     * @return \Magento\Framework\App\ActionInterface|null
     */
    public function match(RequestInterface $request)
    {
        $pathInfo = $request->getPathInfo();
        $find = $request->getParam('find', false);
        if ($find && preg_match("%^/.*/.*\.html$%", $pathInfo, $m)) {
            $pathInfo = str_replace('.html', '', $pathInfo);
            $pathInfo = $pathInfo . '/' . $find . '/';
            $request->setPathInfo($pathInfo);
            return $this->actionFactory->create(
                'Magento\Framework\App\Action\Forward',
                ['request' => $request]
            );
        }
        return null;
    }
}
