<?php

namespace Misterllantas\Buscadorllantas\Model;

use Magento\Framework\Model\AbstractModel;
use Magento\Framework\DataObject\IdentityInterface;
use Misterllantas\Buscadorllantas\Api\Data\CarInterface;
use Misterllantas\Buscadorllantas\Model\ResourceModel\Car as ResourceModel;

class Car extends AbstractModel implements IdentityInterface, CarInterface
{
	/**
	 * CMS page cache tag
	 */
	const CACHE_TAG = 'misterllanta_Buscadorllantas_car';

	/**
	 * @var string
	 */
	protected $_cacheTag = 'misterllanta_Buscadorllantas_car';

	/**
	 * Prefix of model events names
	 *
	 * @var string
	 */

	protected $_eventPrefix = 'misterllanta_Buscadorllantas_car';

	protected function _construct()
	{
		$this->_init(ResourceModel::class);
	}

	/**
	 * Return unique ID(s) for each object in system
	 *
	 * @return array
	 */

	public function getIdentities()
	{
		return [self::CACHE_TAG . '_' . $this->getId()];
	}

	/**
	 * Get ID
	 *
	 * @return int|null
	 */
	public function getId()
	{
		return $this->getData(self::ID);
	}

	/**
	 * Get YEAR
	 *
	 * @return string|null
	 */
	public function getYear()
	{
		return $this->getData(self::YEAR);
	}

	/**
	 * Get Vendor
	 *
	 * @return string|null
	 */
	public function getVendor()
	{
		return $this->getData(self::VENDOR);
	}

	/**
	 * Get Car
	 *
	 * @return string|null
	 */
	public function getCar()
	{
		return $this->getData(self::CAR);
	}

	/**
	 * Get Modification
	 *
	 * @return string|null
	 */
	public function getModification()
	{
		return $this->getData(self::MODIFICATION);
	}

	/**
	 * Get Modification
	 *
	 * @return string|null
	 */
	public function getTyres_factory()
	{
		return $this->getData(self::TYRES_FACTORY);
	}

	/**
	 * Get Vendor_Slug
	 *
	 * @return string|null
	 */
	public function getVendor_slug()
	{
		return $this->getData(self::VENDOR_SLUG);
	}

	/**
	 * Get Car_Slug
	 *
	 * @return string|null
	 */
	public function getCar_slug()
	{
		return $this->getData(self::CAR_SLUG);
	}

	/**
	 * Get Car_Slug
	 *
	 * @return string|null
	 */
	public function getModification_slug()
	{
		return $this->getData(self::MODIFICATION_SLUG);
	}

    /**
     * Set ID
     *
     * @param int $id
     * @return \Misterllantas\Buscadorllantas\Api\Data\CarInterface
     */
    public function setId($id)
    {
        // TODO: Implement setId() method.
    }

    /**
     * Set title
     *
     * @param string $year
     * @return \Misterllantas\Buscadorllantas\Api\Data\CarInterface
     */
    public function setYear($year)
    {
        // TODO: Implement setYear() method.
    }

    /**
     * Set Vendor
     *
     * @param string $vendor
     * @return \Misterllantas\Buscadorllantas\Api\Data\CarInterface
     */
    public function setVendor($vendor)
    {
        // TODO: Implement setVendor() method.
    }

    /**
     * Set creation car
     *
     * @param string $car
     * @return \Misterllantas\Buscadorllantas\Api\Data\CarInterface
     */
    public function setCar($car)
    {
        // TODO: Implement setCar() method.
    }

    /**
     * Set update modificacion
     *
     * @param $modification
     * @return \Misterllantas\Buscadorllantas\Api\Data\CarInterface
     */
    public function setModification($modification)
    {
        // TODO: Implement setModification() method.
    }

    /**
     * Set is Tyres Factory
     *
     * @param $tyres_factory
     * @return \Misterllantas\Buscadorllantas\Api\Data\CarInterface
     */
    public function setTyres_Factory($tyres_factory)
    {
        // TODO: Implement setTyres_Factory() method.
    }

    /**
     * Set is vendor_slug
     *
     * @param int|bool $vendor_slug
     * @return \Misterllantas\Buscadorllantas\Api\Data\CarInterface
     */
    public function setVendor_Slug($vendor_slug)
    {
        // TODO: Implement setVendor_Slug() method.
    }

    /**
     * Set Car_Slug
     *
     * @param int|bool $car_slug
     * @return \Misterllantas\Buscadorllantas\Api\Data\CarInterface
     */
    public function setCar_Slug($car_slug)
    {
        // TODO: Implement setCar_Slug() method.
    }

    /**
     * Set is Modification_Slug
     *
     * @param int|bool $modification_slug
     * @return \Misterllantas\Buscadorllantas\Api\Data\CarInterface
     */
    public function setModification_Slug($modificacion_slug)
    {
        // TODO: Implement setModification_Slug() method.
    }
}
