<?php
namespace Misterllantas\Buscadorllantas\Setup;

use Magento\Framework\DB\Ddl\Table;
use Magento\Framework\Setup\InstallSchemaInterface;
use Magento\Framework\Setup\ModuleContextInterface;
use Magento\Framework\Setup\SchemaSetupInterface;

class InstallSchema implements InstallSchemaInterface
{
  
    public function install(SchemaSetupInterface $setup, ModuleContextInterface $context)
    {
          /**
          * Create table 'buscadorllantas'
          */
          $table = $setup->getConnection()
              ->newTable($setup->getTable('buscadorllantas'))
              ->addColumn(
                'id',
                Table::TYPE_INTEGER,
                null,
                [
                    'identity' => true,
                    'unsigned' => true,
                    'nullable' => false,
                    'primary' => true
                ],
                'ID'
            )
            ->addColumn(
                'year',
                Table::TYPE_TEXT,
                255,
                ['nullable' => false,],
                'Year'
            )
            ->addColumn(
                'vendor',
                Table::TYPE_TEXT,
                255,
                ['nullable' => false,],
                'Vendor'
            )
            ->addColumn(
                'car',
                Table::TYPE_TEXT,
                255,
                ['nullable' => false,],
                'Car'
            )
            ->addColumn(
                'modification',
                Table::TYPE_TEXT,
                null,
                ['nullable' => false,],
                'Modification'
            )
            ->addColumn(
                'tyres_factory',
                Table::TYPE_TEXT,
                255,
                ['nullable' => true,],
                'Tyres Factory'
            )
            ->addColumn(
                'vendor_slug',
                Table::TYPE_TEXT,
                null,
                ['nullable' => false,],
                'Vendor Slug'
            )
            ->addColumn(
                'car_slug',
                Table::TYPE_TEXT,
                255,
                ['nullable' => false,],
                'Car Slug'
            )
            ->addColumn(
                'modification_slug',
                Table::TYPE_TEXT,
                255,
                ['nullable' => false,],
                'Modification Slug'
            );
          $setup->getConnection()->createTable($table);
      }
}
