<?php

namespace Misterllantas\Customminicart\Plugin;

use Magento\Catalog\Api\ProductRepositoryInterface;
use Magento\Catalog\Model\Product;
use Magento\Quote\Model\Quote\Item;

class DefaultItem
{

    protected $productRepository;

    public function __construct(ProductRepositoryInterface $productRepository)
    {
        $this->productRepository = $productRepository;
    }

    public function aroundGetItemData($subject, \Closure $proceed, Item $item)
    {
        $data = $proceed($item);

        /** @var Product $product */
        $product = $this->productRepository->getById($item->getProduct()->getId());
        $attributes = $product->getAttributes();

        $atts = [
            "medida" => $attributes['medida']->getFrontend()->getValue($product),
            "carga" => $attributes['indice_carga']->getFrontend()->getValue($product),
            "velocidad" =>$attributes['indice_velocidad']->getFrontend()->getValue($product)
        ];

        return array_merge($data, $atts);
    }
}