/**
 * Copyright © 2016 Magento. All rights reserved.
 * See COPYING.txt for license details.
 */
 
define(
    [
        'uiComponent'
    ],
    function (Component) {
        "use strict";
        var quoteItemData = window.checkoutConfig.quoteItemData;
        return Component.extend({
        defaults: {
            template: 'Misterllantas_Customsummary/summary/item/details'
        },
        quoteItemData: quoteItemData,
        getValue: function(quoteItem) {
            return quoteItem.name;
        },
        
        getMedida: function(quoteItem) {
            var item = this.getItem(quoteItem.item_id);
            return item.medida;
        },
        getCarga: function(quoteItem) {
            var item = this.getItem(quoteItem.item_id);
            return item.carga;
        },
        getVelocidad: function(quoteItem) {
            var item = this.getItem(quoteItem.item_id);
            return item.velocidad;
        },
        getItem: function(item_id) {
            var itemElement = null;
            _.each(this.quoteItemData, function(element, index) {
                if(element.item_id == item_id) {
                    itemElement = element;
                }
            })
            return itemElement;
        }
    });
});