<?php

namespace Olegnax\Athlete2\Model\DynamicStyle;

use Exception;
use Magento\Framework\Filesystem\Driver\File;
use Magento\Framework\Message\ManagerInterface as MessageManager;
use Magento\Framework\Registry;
use Magento\Framework\View\LayoutInterface as ViewLayout;
use Magento\Store\Model\StoreManagerInterface as StoreManager;
use Olegnax\Athlete2\Helper\CssFiles;

class Generator
{

    /**
     * Store Manager
     *
     * @var \Magento\Store\Model\StoreManagerInterface
     */
    private $_storeManager;

    /**
     * Theme css files
     *
     * @var \Olegnax\Athlete2\Helper\CssFiles
     */
    private $_cssFiles;

    /**
     * Registry
     *
     * @var \Magento\Framework\Registry
     */
    private $_registry;

    /**
     * File
     *
     * @var \Magento\Framework\Filesystem\Driver\File
     */
    private $_file;

    /**
     * View Layout
     *
     * @var \Magento\Framework\View\LayoutInterface
     */
    private $_viewLayout;

    /**
     * Store Manager
     *
     * @var \Magento\Framework\Message\ManagerInterface
     */
    private $_messageManager;

    /**
     *
     * @param \Magento\Store\Model\StoreManagerInterface $storeManager
     * @param \Olegnax\Athlete2\Helper\CssFiles $cssFiles
     * @param \Magento\Framework\Registry $registry
     * @param \Magento\Framework\Filesystem\Driver\File $file
     * @param \Magento\Framework\View\LayoutInterface $viewLayout
     * @param \Magento\Framework\Message\ManagerInterface $messageManager
     */
    public function __construct(
        StoreManager $storeManager,
        CssFiles $cssFiles,
        Registry $registry,
        File $file,
        ViewLayout $viewLayout,
        MessageManager $messageManager
    ) {
        $this->_storeManager = $storeManager;
        $this->_cssFiles = $cssFiles;
        $this->_registry = $registry;
        $this->_file = $file;
        $this->_viewLayout = $viewLayout;
        $this->_messageManager = $messageManager;
    }

    public function generate($type, $website, $store)
    {
        $this->generateCSS($type, $website, $store);
    }

    public function generateCSS($type, $website, $store)
    {
        if (!empty($website)) {
            $this->generateWebsite($type, $website, 'css');
        } elseif (!empty($store)) {
            $this->generateStore($type, $store, 'css');
        } else {
            $this->generateAll($type, 'css');
        }
    }

    private function generateWebsite($type, $id, $format)
    {
        $website = $this->_storeManager->getWebsite($id);
        $stores = $website->getStoreIds();
        if (!empty($stores) && is_array($stores)) {
            foreach ($stores as $store) {
                $this->generateStore($type, $store, $format);
            }
        }
    }

    private function generateStore($type, $id, $format)
    {
        $store = $this->_storeManager->getStore($id);
        if (!$store->isActive()) {
            return;
        }
        $storeCode = $store->getCode();
        $dynamicTemplate = sprintf('dynamic_%s/%s.phtml', $format, $type);
        $dynamicFile = sprintf('%s/%s_%s.%s', $this->_cssFiles->getDymanicDir(), $type, $storeCode, $format);

        try {
            $this->_file->createDirectory(dirname($dynamicFile), 0755);
            $content = '';
            if ($block = $this->_viewLayout->getBlock($type . $storeCode . $format)) {
                $content = $block->setData(['area' => 'frontend', 'dynamic_store_code' => $storeCode])->setTemplate($dynamicTemplate)->toHtml();
            } else {
                $content = $this->_viewLayout->createBlock('Olegnax\Athlete2\Block\Template', $type . $storeCode . $format, ['data' => ['area' => 'frontend', 'dynamic_store_code' => $storeCode]])->setTemplate($dynamicTemplate)->toHtml();
            }
            if (!empty($content)) {
                $content = preg_replace('/[\r\n\t]/', ' ', $content);
                $content = preg_replace('/[\r\n\t ]{2,}/', ' ', $content);
                $content = preg_replace('/\s+(\:|\;|\{|\})\s+/', '\1', $content);
            }
            $this->_file->filePutContents($dynamicFile, $content);
        } catch (Exception $e) {
            $this->_messageManager->addError(sprintf(__('Failed generaing file: %s<br/>Message: %s'), str_replace(BP, '', $dynamicFile), $e->getMessage()));
        }
    }

    private function generateAll($type, $format)
    {
        $websites = $this->_storeManager->getWebsites(false, false);
        if (!empty($websites) && is_array($websites)) {
            foreach ($websites as $website => $value) {
                $this->generateWebsite($type, $website, $format);
            }
        }
    }
}
