<?php

/**/

namespace Olegnax\ProductSlider\Block\Adminhtml;

use Magento\Backend\Block\Template;
use Magento\Backend\Block\Template\Context;
use Magento\Framework\Data\Form\Element\AbstractElement;
use Magento\Framework\Data\Form\Element\Factory;

Class TextField extends Template
{

	protected $_elementFactory;

	/**
	 * @param Context $context
	 * @param Factory $elementFactory
	 * @param array $data
	 */
	public function __construct(
		Context $context, Factory $elementFactory,
		array $data = []
	)
	{
		$this->_elementFactory = $elementFactory;
		parent::__construct($context, $data);
	}

	/**
	 * Prepare chooser element HTML
	 *
	 * @param AbstractElement $element Form Element
	 * @return AbstractElement
	 */
	public function prepareElementHtml(AbstractElement $element)
	{
		$input = $this->_elementFactory->create("textarea", ['data' => $element->getData()]);
		$input->setId($element->getId());
		$input->setForm($element->getForm());
		$input->setClass("widget-option input-textarea admin__control-text");
		if ($element->getRequired()) {
			$input->addClass('required-entry');
		}

		$element->setData('after_element_html', $input->getElementHtml());
		return $element;
	}

}
