<?php

namespace StripeIntegration\Payments\Observer;

use Magento\Framework\Event\Observer;
use Magento\Payment\Observer\AbstractDataAssignObserver;
use StripeIntegration\Payments\Helper\Logger;

class QuoteObserver extends AbstractDataAssignObserver
{
    public $hasSubscriptions = null;

    public function __construct(
        \StripeIntegration\Payments\Helper\Generic $helper,
        \StripeIntegration\Payments\Model\Config $config,
        \StripeIntegration\Payments\Model\Tax\Calculation $taxCalculation
    )
    {
        $this->helper = $helper;
        $this->config = $config;
        $this->taxCalculation = $taxCalculation;
    }

    /**
     * @param Observer $observer
     * @return void
     */
    public function execute(Observer $observer)
    {
        $quote = $observer->getEvent()->getQuote();
        $eventName = $observer->getEvent()->getName();

        if (empty($quote) || !$this->config->isEnabled())
            return;

        $this->taxCalculation->method = null;

        if ($this->hasSubscriptions === null)
            $this->hasSubscriptions = $this->helper->hasSubscriptionsIn($quote->getAllItems());

        if ($this->hasSubscriptions || $this->helper->isAdmin())
            $this->taxCalculation->method = \Magento\Tax\Model\Calculation::CALC_ROW_BASE;
    }
}
