<?php
namespace Swissup\CheckoutCart\Plugin\Model;

class ConfigProvider
{
    /**
     * @var \Swissup\CheckoutCart\Helper\Data
     */
    protected $helper;
    /**
     * @param \Swissup\CheckoutCart\Helper\Data $helper
     */
    public function __construct(
        \Swissup\CheckoutCart\Helper\Data $helper
    ) {
        $this->helper = $helper;
    }
    /**
     * @param \Magento\Checkout\Model\DefaultConfigProvider $subject
     * @param array $result
     * @return string
     */
    public function afterGetConfig(
        \Magento\Checkout\Model\DefaultConfigProvider $subject,
        array $result
    ) {
        $result['swissup']['CheckoutCart']['enabled'] = $this->helper->isEnabled();
        $result['swissup']['CheckoutCart']['productLinkEnabled'] = $this->helper->productLinkEnabled();

        //se modifico el di.xml y se usa otro config provider.php, se agrego info al .js mixin
        //fuxz 4 de abril 2020 1:20pm
        //consultar la diferencia entre la extension original y esta para ver las diferencias

        return $result;
    }
}
