<?php

namespace Swissup\CheckoutSuccess\Block\Order\Items;

use Magento\Framework\View\Element\AbstractBlock;
use Magento\Catalog\Block\Product\ImageBuilder;
use Magento\Framework\View\Element\Context;

class Image extends AbstractBlock
{
    /**
     * @var ImageBuilder
     */
    protected $imageBuilder;

    /**
     * @param ItemResolver $itemResolver
     * @param ImageBuilder $imageBuilder
     * @param Context      $context
     * @param array        $data
     */
    public function __construct(
        ImageBuilder $imageBuilder,
        Context $context,
        array $data = []
    ) {
        $this->imageBuilder = $imageBuilder;
        parent::__construct($context, $data);
    }

    /**
     * Get product image for ordered item
     *
     * @param  \Magento\Sales\Model\Order\Item $item
     * @return string
     */
    public function getImageHtml(\Magento\Sales\Model\Order\Item $item)
    {
        $product = $item->getProduct();
        $imageId = $this->getProductImageId();

        return $this->imageBuilder->create($product, $imageId)->toHtml();
    }
}
