<?php

namespace Zip\ZipPayment\Model\Config\Source;

use \Zip\ZipPayment\Logger\Logger as ZipMoneyLogger;

/**
 * Used in creating options for sandbox|production config value selection
 * @author    Zip Plugin Team <integrations@zip.co>
 * @copyright 2020 Zip Co Limited
 * @link      https://zip.co
 */
class LogSettings implements \Magento\Framework\Option\ArrayInterface
{
    /**
     * Options getter
     *
     * @return array
     */
    public function toOptionArray()
    {
        return [['value' => ZipMoneyLogger::DEBUG, 'label' => __('Debug')],
            ['value' => ZipMoneyLogger::INFO, 'label' => __('Info')],
            ['value' => -1, 'label' => __('None')]];
    }
}
