define([
    'Magento_Payment/js/view/payment/cc-form',
    'jquery',
    'mage/url',
    'Magento_Checkout/js/model/quote'
], function (
    Component,
    $,
    url,
    quote
) {
    'use strict';

    return Component.extend({
        defaults: {
            template: 'Aplazo_AplazoPayment/payment/aplazo-form'
        },

        getTitle: function () {
            return this.item.title;
        },

        getCode: function() {
            return this.item.method;
        },

        isActive: function() {
            return true;
        },

        getSubtitle: function(){
            return aplazoSubtitle;
        },

        validate: function() {
            var $form = $('#' + this.getCode() + '-form');
            return true;
        },

        continueWithAplazo: function (data, event) {
            let _this = this;
            jQuery('body').loader('show');
            var email = quote.guestEmail;
            $.ajax({
                url: url.build('aplazopayment/index/onplaceorder?email='+email),
                type: 'GET',
                cache: false,

                success: function (response) {
                    jQuery('body').loader('hide');
                    if (response.error === false && response.redirecturl !== null) {
                        let url = response.redirecturl;
                        window.location = url;
                    } else {
                        console.log(response);
                    }
                },
                error: function (response) {
                    jQuery('body').loader('hide');
                    console.log(response);
                }
            });
        },
    });
});
