<?php

namespace Misterllantas\Facturacion\Api\Data;

interface FacturacionInterface
{
    /**
     * Constants for keys of data array. Identical to the name of the getter in snake case
     */
    const ID = 'id';
    const NUMEROPEDIDO = 'NumeroPedido';
    const RFC = 'rfc';
    const NOMBRECOMPLETO = 'NombreCompleto';
    const EMAIL = 'Email';
    const USOCFDI = 'UsoCFDI';
    const CODIGOPOSTAL = 'CodigoPostal';
    const STATUS = 'Status';
    const CREATED_AT = 'created_at';

    /**
     * @return string|null
     */
    public function getId();

    /**
     * @return string|null
     */
    public function getNumeroPedido();

    /**
     * @return string|null
     */
    public function getrfc();

    /**
     * @return string|null
     */
    public function getNombreCompleto();

    /**
     * @return string|null
     */
    public function getEmail();

    /**
     * @return string|null
     */
    public function getUsoCFI();

    /**
     * @return string|null
     */
    public function getCodigoPostal();

    /**
     * @return string|null
     */
    public function getStatus();

    /**
     * @return string|null
     */
    public function getCreatedAt();

    /**
     * @param int $id
     *
     * @return \Misterllantas\Facturacion\Api\Data\FacturacionInterface
     */
    public function setId($id);

    /**
     * @param string $numeroPedido
     *
     * @return \Misterllantas\Facturacion\Api\Data\FacturacionInterface
     */
    public function setNumeroPedido($NumeroPedido);

    /**
     * @param string $rfc
     *
     * @return \Misterllantas\Facturacion\Api\Data\FacturacionInterface
     */
    public function setrfc($rfc);

    /**
     * @param string  $nombreCompleto
     *
     * @return \Misterllantas\Facturacion\Api\Data\FacturacionInterface
     */
    public function setNombreCompleto($NombreCompleto);

    /**
     * @param string $email
     *
     * @return \Misterllantas\Facturacion\Api\Data\FacturacionInterface
     */
    public function setEmail($Email);

    /**
     * @param string $UsoCFI
     *
     * @return \Misterllantas\Facturacion\Api\Data\FacturacionInterface
     */
    public function setUsoCFI($UsoCFDI);

    /**
     *@param string $codigoPostal
     *
     * @return \Misterllantas\Facturacion\Api\Data\FacturacionInterface
     */
    public function setCodigoPostal($CodigoPostal);

    /**
     * @param string $status
     *
     * @return \Misterllantas\Facturacion\Api\Data\FacturacionInterface
     */
    public function setStatus($Status);

    /**
     * @param string  $createdAt
     *
     * @return \Misterllantas\Facturacion\Api\Data\FacturacionInterface
     */
    public function setCreatedAt($created_at);
}
