<?php

namespace Misterllantas\Facturacion\Controller\Index;

use Magento\Framework\Controller\ResultFactory;
use Magento\Framework\App\Action\Context;
use Magento\Framework\App\RequestInterface;
use Misterllantas\Facturacion\Model\FacturacionFactory;

class Index extends \Magento\Framework\App\Action\Action
{

    protected $_dataFacturacionFactory;
    protected $resultRedirect;

    public function __construct(
        Context $context,
        ResultFactory  $result,
        RequestInterface $request,
        FacturacionFactory  $dataFacturacionFactory
    ) {
        parent::__construct($context);
        $this->resultRedirect = $result;
        $this->request = $request;
        $this->_dataFacturacionFactory = $dataFacturacionFactory;
    }

    public function execute()
    {
        //$request = (array) $this->getRequest()->getPost();
        $request =  $this->request->getPostValue();
        if (!empty($request)) {
            // Retrieve your form data
            $NumeroPedido   = $request['NumeroPedido'];
            $rfc = $request['rfc'];
            $NombreCompleto = $request['NombreCompleto'];
            $Email = $request['Email'];
            $UsoCFDI = $request['UsoCFDI'];
            $CodigoPostal = $request['CodigoPostal'];

            if (!empty($NumeroPedido) && !empty($rfc) && !empty($NombreCompleto) && !empty($Email) && !empty($UsoCFDI) && !empty($CodigoPostal)) {
                $model = $this->_dataFacturacionFactory->create();
                $model->addData([
                    "NumeroPedido" => $NumeroPedido,
                    "rfc" => $rfc,
                    "NombreCompleto" => $NombreCompleto,
                    "Email" => $Email,
                    "UsoCFDI" => $UsoCFDI,
                    "CodigoPostal" => $CodigoPostal,
                    "Status" => 'Solicitada'
                ]);
                $saveData = $model->save();
            }

            if ($saveData) {
                $this->messageManager->addSuccess(__('Gracias por enviar tus datos. Se enviara tu factura al correo que proporcionaste.'));
                $resultRedirect = $this->resultRedirect->create(ResultFactory::TYPE_REDIRECT);
                $resultRedirect->setUrl($this->_redirect->getRefererUrl());
            } else {
                $this->_messageManager->addError(__("Ocurrio  un error favor intentar de nuevo."));
                $resultRedirect = $this->resultRedirect->create(ResultFactory::TYPE_REDIRECT);
                $resultRedirect->setUrl($this->_redirect->getRefererUrl());
            }
            return $resultRedirect;
        }
        //renderiza el formulario 
        $this->_view->loadLayout();
        $this->_view->renderLayout();
    }
}
