<?php

namespace Misterllantas\Facturacion\Model\Api;

use Psr\Log\LoggerInterface;
use Misterllantas\Facturacion\Model\FacturacionFactory;
use Misterllantas\Facturacion\Api\FacturacionManagementInterface;

class FacturacionManagement implements FacturacionManagementInterface
{
    protected $logger;
    protected $_dataFacturacionFactory;
    public function __construct(
        LoggerInterface $logger,
        FacturacionFactory  $dataFacturacionFactory
    ) {
        $this->logger = $logger;
        $this->_dataFacturacionFactory = $dataFacturacionFactory;
    }

    public function getFacturas($pageSize, $page)
    {
        $arrayResponse  = [];

        try {
            if (!empty($pageSize) && !empty($page)) {

                $collection = $this->_dataFacturacionFactory->create()->getCollection();
                $total_count = count($collection);
                $collection->setOrder('id', 'DESC');
                $collection->setPageSize($pageSize);
                $collection->setCurPage($page);
                // $collection->setAvailableLimit([10 => 10]);


                if (!$collection) {
                    throw new \Magento\Framework\Exception\LocalizedException(
                        __('no data found')
                    );
                };

                array_push(
                    $arrayResponse,
                    [
                        'data' =>
                        $collection->getData(),

                        "search_criteria" => [
                            "filter_groups" => [],
                            "page_size" => $pageSize,
                            "current_page" => $page
                        ],
                        'total_count' => $total_count
                    ]
                );
            }
        } catch (\Exception $e) {
            $arrayResponse = ['success' => false, 'message' => $e->getMessage()];
            $this->logger->info($e->getMessage());
        }

        return $arrayResponse;
    }


    public function postFacturas($NumeroPedido, $Status)
    {
        $arrayResponse  = [[
            'success' => true
        ]];

        try {
            if (!empty($NumeroPedido) && !empty($Status)) {

                $model = $this->_dataFacturacionFactory->create();
                $model->load($NumeroPedido, 'NumeroPedido');

                if ($model->getData('NumeroPedido') !== $NumeroPedido) {
                    throw new \Magento\Framework\Exception\LocalizedException(
                        __('no data found')
                    );
                }

                $model->setData('Status', $Status);
                if ($model->save()) {
                    array_push(
                        $arrayResponse,
                        [
                            'items' => [
                                'NumeroPedido' => $model->getNumeroPedido(),
                                'Status' => $model->getStatus()
                            ]
                        ]
                    );
                }
            }
        } catch (\Exception $e) {
            $arrayResponse  = ['success' => false, 'message' => $e->getMessage()];
            $this->logger->info($e->getMessage());
        }

        return $arrayResponse;
    }
}
