<?php

namespace Misterllantas\Facturacion\Model;

use Magento\Framework\Model\AbstractModel;
use Magento\Framework\DataObject\IdentityInterface;
use Misterllantas\Facturacion\Api\Data\FacturacionInterface;
use Misterllantas\Facturacion\Model\ResourceModel\Facturacion as ResourceModel;

/**
 * Class Facturacion
 * @package Misterllantas\Facturacion\Model
 */
class Facturacion extends AbstractModel implements IdentityInterface, FacturacionInterface
{
	/**
	 * CMS page cache tag
	 */
	const CACHE_TAG = 'misterllantas_Facturacion';

	/**
	 * @var string
	 */
	protected $_cacheTag = 'misterllantas_Facturacion';

	/**
	 * Prefix of model events names
	 *
	 * @var string
	 */

	protected $_eventPrefix = 'misterllantas_Facturacion';

	public function _construct()
	{
		$this->_init(ResourceModel::class);
	}

	/**
	 * Return unique ID(s) for each object in system
	 *
	 * @return array
	 */

	public function getIdentities()
	{
		return [self::CACHE_TAG . '_' . $this->getId()];
	}

	/**
	 * Get ID
	 *
	 * @return int|null
	 */
	public function getId()
	{
		return $this->getData(self::ID);
	}

	/**
	 * @return string|null
	 */
	public function getNumeroPedido()
	{
		return $this->getData(self::NUMEROPEDIDO);
	}


	/**
	 * @return string|null
	 */
	public function getrfc()
	{
		return $this->getData(self::RFC);
	}

	/**
	 * @return string|null
	 */
	public function getNombreCompleto()
	{
		return $this->getData(self::NOMBRECOMPLETO);
	}

	/**
	 * @return string|null
	 */
	public function getEmail()
	{
		return $this->getData(self::EMAIL);
	}

	/**
	 * @return string|null
	 */
	public function getUsoCFI()
	{
		return $this->getData(self::USOCFDI);
	}

	/**
	 * @return string|null
	 */
	public function getCodigoPostal()
	{
		return $this->getData(self::CODIGOPOSTAL);
	}

	/**
	 * @return string|null
	 */
	public function getStatus()
	{
		return $this->getData(self::STATUS);
	}

	/**
	 * @return string|null
	 */
	public function getCreatedAt()
	{
		return $this->getData(self::CREATED_AT);
	}

	/**
	 * @param int $id
	 *
	 * @return \Misterllantas\Facturacion\Api\Data\FacturacionInterface
	 */
	public function setId($id)
	{
		// TODO: Implement setId() method.
	}

	/**
	 * @param string $numeroPedido
	 *
	 * @return \Misterllantas\Facturacion\Api\Data\FacturacionInterface
	 */
	public function setNumeroPedido($numeroPedido)
	{
		// TODO: Implement setNumeroPedido() method.
	}

	/**
	 * @param string $rfc
	 *
	 * @return \Misterllantas\Facturacion\Api\Data\FacturacionInterface
	 */
	public function setrfc($rfc)
	{
		// TODO: Implement setrfc() method.
	}

	/**
	 * @param string  $nombreCompleto
	 *
	 * @return \Misterllantas\Facturacion\Api\Data\FacturacionInterface
	 */
	public function setNombreCompleto($nombreCompleto)
	{
		// TODO: Implement setNombreCompleto() method.
	}

	/**
	 * @param string $email
	 *
	 * @return \Misterllantas\Facturacion\Api\Data\FacturacionInterface
	 */
	public function setEmail($email)
	{
		// TODO: Implement setEmail() method.
	}

	/**
	 * @param string $UsoCFI
	 *
	 * @return \Misterllantas\Facturacion\Api\Data\FacturacionInterface
	 */
	public function setUsoCFI($usoCFI)
	{
		// TODO: Implement setUsoCFI() method.
	}

	/**
	 *@param string $codigoPostal
	 *
	 * @return \Misterllantas\Facturacion\Api\Data\FacturacionInterface
	 */
	public function setCodigoPostal($codigoPostal)
	{
		// TODO: Implement setCodigoPostal() method.
	}

	/**
	 * @param string $status
	 *
	 * @return \Misterllantas\Facturacion\Api\Data\FacturacionInterface
	 */
	public function setStatus($status)
	{
		// TODO: Implement setStatus() method.
	}

	/**
	 * @param string  $createdAt
	 *
	 * @return \Misterllantas\Facturacion\Api\Data\FacturacionInterface
	 */
	public function setCreatedAt($created_at)
	{
		// TODO: Implement setCreatedAt() method.
	}
}
