<?php

namespace Misterllantas\Facturacion\Setup;

use Magento\Framework\Setup\SchemaSetupInterface;
use Magento\Framework\Setup\ModuleContextInterface;
use Magento\Framework\DB\Ddl\Table;
use Magento\Framework\Setup\InstallSchemaInterface;

class InstallSchema implements InstallSchemaInterface
{

    public function install(SchemaSetupInterface $setup, ModuleContextInterface $context)
    {
        /**
         * Create table 'data_facturacion'
         */

        $table = $setup->getConnection()
            ->newTable($setup->getTable('data_facturacion'))
            ->addColumn(
                'id',
                Table::TYPE_INTEGER,
                null,
                [
                    'identity' => true,
                    'unsigned' => true,
                    'nullable' => false,
                    'primary' => true
                ],
                'ID'
            )
            ->addColumn(
                'NumeroPedido',
                Table::TYPE_TEXT,
                255,
                ['nullable' => false,],
                'Numero Pedido'
            )
            ->addColumn(
                'rfc',
                Table::TYPE_TEXT,
                255,
                ['nullable' => false,],
                'RFC'
            )
            ->addColumn(
                'NombreCompleto',
                Table::TYPE_TEXT,
                255,
                ['nullable' => false,],
                'Nombre Completo'
            )
            ->addColumn(
                'Email',
                Table::TYPE_TEXT,
                255,
                ['nullable' => false,],
                'Email'
            )
            ->addColumn(
                'UsoCFDI',
                Table::TYPE_TEXT,
                255,
                ['nullable' => false,],
                'Uso CFDI'
            )
            ->addColumn(
                'CodigoPostal',
                Table::TYPE_TEXT,
                255,
                ['nullable' => false,],
                'Codigo Postal'
            )
            ->addColumn(
                'Status',
                Table::TYPE_TEXT,
                255,
                ['nullable' => true,],
                'Status'
            )
            ->addColumn(
                'created_at',
                \Magento\Framework\DB\Ddl\Table::TYPE_TIMESTAMP,
                null,
                ['nullable' => false, 'default' => \Magento\Framework\DB\Ddl\Table::TIMESTAMP_INIT],
                'Fecha Creacion'
            );
        $setup->getConnection()->createTable($table);
    }
}
