<?php
namespace Magento\Quote\Api\Data;

/**
 * Extension class for @see \Magento\Quote\Api\Data\CartInterface
 */
class CartExtension extends \Magento\Framework\Api\AbstractSimpleObject implements CartExtensionInterface
{
    /**
     * @return \Magento\Quote\Api\Data\ShippingAssignmentInterface[]|null
     */
    public function getShippingAssignments()
    {
        return $this->_get('shipping_assignments');
    }

    /**
     * @param \Magento\Quote\Api\Data\ShippingAssignmentInterface[] $shippingAssignments
     * @return $this
     */
    public function setShippingAssignments($shippingAssignments)
    {
        $this->setData('shipping_assignments', $shippingAssignments);
        return $this;
    }

    /**
     * @return \Amasty\Acart\Api\Data\QuoteEmailInterface|null
     */
    public function getAmAcartQuoteEmail()
    {
        return $this->_get('am_acart_quote_email');
    }

    /**
     * @param \Amasty\Acart\Api\Data\QuoteEmailInterface $amAcartQuoteEmail
     * @return $this
     */
    public function setAmAcartQuoteEmail(\Amasty\Acart\Api\Data\QuoteEmailInterface $amAcartQuoteEmail)
    {
        $this->setData('am_acart_quote_email', $amAcartQuoteEmail);
        return $this;
    }
}
