<?php
namespace Magento\Quote\Api\Data;

/**
 * Extension class for @see \Magento\Quote\Api\Data\TotalSegmentInterface
 */
class TotalSegmentExtension extends \Magento\Framework\Api\AbstractSimpleObject implements TotalSegmentExtensionInterface
{
    /**
     * @return \Magento\Tax\Api\Data\GrandTotalDetailsInterface[]|null
     */
    public function getTaxGrandtotalDetails()
    {
        return $this->_get('tax_grandtotal_details');
    }

    /**
     * @param \Magento\Tax\Api\Data\GrandTotalDetailsInterface[] $taxGrandtotalDetails
     * @return $this
     */
    public function setTaxGrandtotalDetails($taxGrandtotalDetails)
    {
        $this->setData('tax_grandtotal_details', $taxGrandtotalDetails);
        return $this;
    }

    /**
     * @return \MageWorx\MultiFees\Api\Data\FeeDetailsInterface[]|null
     */
    public function getMageworxFeeDetails()
    {
        return $this->_get('mageworx_fee_details');
    }

    /**
     * @param \MageWorx\MultiFees\Api\Data\FeeDetailsInterface[] $mageworxFeeDetails
     * @return $this
     */
    public function setMageworxFeeDetails($mageworxFeeDetails)
    {
        $this->setData('mageworx_fee_details', $mageworxFeeDetails);
        return $this;
    }

    /**
     * @return \MageWorx\MultiFees\Api\Data\FeeDetailsInterface[]|null
     */
    public function getMageworxProductFeeDetails()
    {
        return $this->_get('mageworx_product_fee_details');
    }

    /**
     * @param \MageWorx\MultiFees\Api\Data\FeeDetailsInterface[] $mageworxProductFeeDetails
     * @return $this
     */
    public function setMageworxProductFeeDetails($mageworxProductFeeDetails)
    {
        $this->setData('mageworx_product_fee_details', $mageworxProductFeeDetails);
        return $this;
    }
}
