<?php
namespace Magento\Sales\Api\Data;

/**
 * Extension class for @see \Magento\Sales\Api\Data\InvoiceInterface
 */
class InvoiceExtension extends \Magento\Framework\Api\AbstractSimpleObject implements InvoiceExtensionInterface
{
    /**
     * @return string|null
     */
    public function getMageworxFeeAmount()
    {
        return $this->_get('mageworx_fee_amount');
    }

    /**
     * @param string $mageworxFeeAmount
     * @return $this
     */
    public function setMageworxFeeAmount($mageworxFeeAmount)
    {
        $this->setData('mageworx_fee_amount', $mageworxFeeAmount);
        return $this;
    }

    /**
     * @return string|null
     */
    public function getBaseMageworxFeeAmount()
    {
        return $this->_get('base_mageworx_fee_amount');
    }

    /**
     * @param string $baseMageworxFeeAmount
     * @return $this
     */
    public function setBaseMageworxFeeAmount($baseMageworxFeeAmount)
    {
        $this->setData('base_mageworx_fee_amount', $baseMageworxFeeAmount);
        return $this;
    }

    /**
     * @return string|null
     */
    public function getMageworxFeeTaxAmount()
    {
        return $this->_get('mageworx_fee_tax_amount');
    }

    /**
     * @param string $mageworxFeeTaxAmount
     * @return $this
     */
    public function setMageworxFeeTaxAmount($mageworxFeeTaxAmount)
    {
        $this->setData('mageworx_fee_tax_amount', $mageworxFeeTaxAmount);
        return $this;
    }

    /**
     * @return string|null
     */
    public function getBaseMageworxFeeTaxAmount()
    {
        return $this->_get('base_mageworx_fee_tax_amount');
    }

    /**
     * @param string $baseMageworxFeeTaxAmount
     * @return $this
     */
    public function setBaseMageworxFeeTaxAmount($baseMageworxFeeTaxAmount)
    {
        $this->setData('base_mageworx_fee_tax_amount', $baseMageworxFeeTaxAmount);
        return $this;
    }

    /**
     * @return string|null
     */
    public function getMageworxFeeDetails()
    {
        return $this->_get('mageworx_fee_details');
    }

    /**
     * @param string $mageworxFeeDetails
     * @return $this
     */
    public function setMageworxFeeDetails($mageworxFeeDetails)
    {
        $this->setData('mageworx_fee_details', $mageworxFeeDetails);
        return $this;
    }

    /**
     * @return string|null
     */
    public function getMageworxProductFeeAmount()
    {
        return $this->_get('mageworx_product_fee_amount');
    }

    /**
     * @param string $mageworxProductFeeAmount
     * @return $this
     */
    public function setMageworxProductFeeAmount($mageworxProductFeeAmount)
    {
        $this->setData('mageworx_product_fee_amount', $mageworxProductFeeAmount);
        return $this;
    }

    /**
     * @return string|null
     */
    public function getBaseMageworxProductFeeAmount()
    {
        return $this->_get('base_mageworx_product_fee_amount');
    }

    /**
     * @param string $baseMageworxProductFeeAmount
     * @return $this
     */
    public function setBaseMageworxProductFeeAmount($baseMageworxProductFeeAmount)
    {
        $this->setData('base_mageworx_product_fee_amount', $baseMageworxProductFeeAmount);
        return $this;
    }

    /**
     * @return string|null
     */
    public function getMageworxProductFeeTaxAmount()
    {
        return $this->_get('mageworx_product_fee_tax_amount');
    }

    /**
     * @param string $mageworxProductFeeTaxAmount
     * @return $this
     */
    public function setMageworxProductFeeTaxAmount($mageworxProductFeeTaxAmount)
    {
        $this->setData('mageworx_product_fee_tax_amount', $mageworxProductFeeTaxAmount);
        return $this;
    }

    /**
     * @return string|null
     */
    public function getBaseMageworxProductFeeTaxAmount()
    {
        return $this->_get('base_mageworx_product_fee_tax_amount');
    }

    /**
     * @param string $baseMageworxProductFeeTaxAmount
     * @return $this
     */
    public function setBaseMageworxProductFeeTaxAmount($baseMageworxProductFeeTaxAmount)
    {
        $this->setData('base_mageworx_product_fee_tax_amount', $baseMageworxProductFeeTaxAmount);
        return $this;
    }

    /**
     * @return string|null
     */
    public function getMageworxProductFeeDetails()
    {
        return $this->_get('mageworx_product_fee_details');
    }

    /**
     * @param string $mageworxProductFeeDetails
     * @return $this
     */
    public function setMageworxProductFeeDetails($mageworxProductFeeDetails)
    {
        $this->setData('mageworx_product_fee_details', $mageworxProductFeeDetails);
        return $this;
    }
}
