<?php
namespace Magento\Sales\Api\Data;

/**
 * Extension class for @see \Magento\Sales\Api\Data\OrderInterface
 */
class OrderExtension extends \Magento\Framework\Api\AbstractSimpleObject implements OrderExtensionInterface
{
    /**
     * @return \Magento\Sales\Api\Data\ShippingAssignmentInterface[]|null
     */
    public function getShippingAssignments()
    {
        return $this->_get('shipping_assignments');
    }

    /**
     * @param \Magento\Sales\Api\Data\ShippingAssignmentInterface[] $shippingAssignments
     * @return $this
     */
    public function setShippingAssignments($shippingAssignments)
    {
        $this->setData('shipping_assignments', $shippingAssignments);
        return $this;
    }

    /**
     * @return \Magento\Payment\Api\Data\PaymentAdditionalInfoInterface[]|null
     */
    public function getPaymentAdditionalInfo()
    {
        return $this->_get('payment_additional_info');
    }

    /**
     * @param \Magento\Payment\Api\Data\PaymentAdditionalInfoInterface[] $paymentAdditionalInfo
     * @return $this
     */
    public function setPaymentAdditionalInfo($paymentAdditionalInfo)
    {
        $this->setData('payment_additional_info', $paymentAdditionalInfo);
        return $this;
    }

    /**
     * @return \Magento\GiftMessage\Api\Data\MessageInterface|null
     */
    public function getGiftMessage()
    {
        return $this->_get('gift_message');
    }

    /**
     * @param \Magento\GiftMessage\Api\Data\MessageInterface $giftMessage
     * @return $this
     */
    public function setGiftMessage(\Magento\GiftMessage\Api\Data\MessageInterface $giftMessage)
    {
        $this->setData('gift_message', $giftMessage);
        return $this;
    }

    /**
     * @return \Magento\Tax\Api\Data\OrderTaxDetailsAppliedTaxInterface[]|null
     */
    public function getAppliedTaxes()
    {
        return $this->_get('applied_taxes');
    }

    /**
     * @param \Magento\Tax\Api\Data\OrderTaxDetailsAppliedTaxInterface[] $appliedTaxes
     * @return $this
     */
    public function setAppliedTaxes($appliedTaxes)
    {
        $this->setData('applied_taxes', $appliedTaxes);
        return $this;
    }

    /**
     * @return \Magento\Tax\Api\Data\OrderTaxDetailsItemInterface[]|null
     */
    public function getItemAppliedTaxes()
    {
        return $this->_get('item_applied_taxes');
    }

    /**
     * @param \Magento\Tax\Api\Data\OrderTaxDetailsItemInterface[] $itemAppliedTaxes
     * @return $this
     */
    public function setItemAppliedTaxes($itemAppliedTaxes)
    {
        $this->setData('item_applied_taxes', $itemAppliedTaxes);
        return $this;
    }

    /**
     * @return boolean|null
     */
    public function getConvertingFromQuote()
    {
        return $this->_get('converting_from_quote');
    }

    /**
     * @param boolean $convertingFromQuote
     * @return $this
     */
    public function setConvertingFromQuote($convertingFromQuote)
    {
        $this->setData('converting_from_quote', $convertingFromQuote);
        return $this;
    }

    /**
     * @return string|null
     */
    public function getMageworxFeeAmount()
    {
        return $this->_get('mageworx_fee_amount');
    }

    /**
     * @param string $mageworxFeeAmount
     * @return $this
     */
    public function setMageworxFeeAmount($mageworxFeeAmount)
    {
        $this->setData('mageworx_fee_amount', $mageworxFeeAmount);
        return $this;
    }

    /**
     * @return string|null
     */
    public function getBaseMageworxFeeAmount()
    {
        return $this->_get('base_mageworx_fee_amount');
    }

    /**
     * @param string $baseMageworxFeeAmount
     * @return $this
     */
    public function setBaseMageworxFeeAmount($baseMageworxFeeAmount)
    {
        $this->setData('base_mageworx_fee_amount', $baseMageworxFeeAmount);
        return $this;
    }

    /**
     * @return string|null
     */
    public function getMageworxFeeTaxAmount()
    {
        return $this->_get('mageworx_fee_tax_amount');
    }

    /**
     * @param string $mageworxFeeTaxAmount
     * @return $this
     */
    public function setMageworxFeeTaxAmount($mageworxFeeTaxAmount)
    {
        $this->setData('mageworx_fee_tax_amount', $mageworxFeeTaxAmount);
        return $this;
    }

    /**
     * @return string|null
     */
    public function getBaseMageworxFeeTaxAmount()
    {
        return $this->_get('base_mageworx_fee_tax_amount');
    }

    /**
     * @param string $baseMageworxFeeTaxAmount
     * @return $this
     */
    public function setBaseMageworxFeeTaxAmount($baseMageworxFeeTaxAmount)
    {
        $this->setData('base_mageworx_fee_tax_amount', $baseMageworxFeeTaxAmount);
        return $this;
    }

    /**
     * @return string|null
     */
    public function getMageworxFeeDetails()
    {
        return $this->_get('mageworx_fee_details');
    }

    /**
     * @param string $mageworxFeeDetails
     * @return $this
     */
    public function setMageworxFeeDetails($mageworxFeeDetails)
    {
        $this->setData('mageworx_fee_details', $mageworxFeeDetails);
        return $this;
    }

    /**
     * @return string|null
     */
    public function getMageworxFeeInvoiced()
    {
        return $this->_get('mageworx_fee_invoiced');
    }

    /**
     * @param string $mageworxFeeInvoiced
     * @return $this
     */
    public function setMageworxFeeInvoiced($mageworxFeeInvoiced)
    {
        $this->setData('mageworx_fee_invoiced', $mageworxFeeInvoiced);
        return $this;
    }

    /**
     * @return string|null
     */
    public function getBaseMageworxFeeInvoiced()
    {
        return $this->_get('base_mageworx_fee_invoiced');
    }

    /**
     * @param string $baseMageworxFeeInvoiced
     * @return $this
     */
    public function setBaseMageworxFeeInvoiced($baseMageworxFeeInvoiced)
    {
        $this->setData('base_mageworx_fee_invoiced', $baseMageworxFeeInvoiced);
        return $this;
    }

    /**
     * @return string|null
     */
    public function getMageworxFeeRefunded()
    {
        return $this->_get('mageworx_fee_refunded');
    }

    /**
     * @param string $mageworxFeeRefunded
     * @return $this
     */
    public function setMageworxFeeRefunded($mageworxFeeRefunded)
    {
        $this->setData('mageworx_fee_refunded', $mageworxFeeRefunded);
        return $this;
    }

    /**
     * @return string|null
     */
    public function getBaseMageworxFeeRefunded()
    {
        return $this->_get('base_mageworx_fee_refunded');
    }

    /**
     * @param string $baseMageworxFeeRefunded
     * @return $this
     */
    public function setBaseMageworxFeeRefunded($baseMageworxFeeRefunded)
    {
        $this->setData('base_mageworx_fee_refunded', $baseMageworxFeeRefunded);
        return $this;
    }

    /**
     * @return string|null
     */
    public function getMageworxFeeCancelled()
    {
        return $this->_get('mageworx_fee_cancelled');
    }

    /**
     * @param string $mageworxFeeCancelled
     * @return $this
     */
    public function setMageworxFeeCancelled($mageworxFeeCancelled)
    {
        $this->setData('mageworx_fee_cancelled', $mageworxFeeCancelled);
        return $this;
    }

    /**
     * @return string|null
     */
    public function getBaseMageworxFeeCancelled()
    {
        return $this->_get('base_mageworx_fee_cancelled');
    }

    /**
     * @param string $baseMageworxFeeCancelled
     * @return $this
     */
    public function setBaseMageworxFeeCancelled($baseMageworxFeeCancelled)
    {
        $this->setData('base_mageworx_fee_cancelled', $baseMageworxFeeCancelled);
        return $this;
    }

    /**
     * @return string|null
     */
    public function getMageworxProductFeeAmount()
    {
        return $this->_get('mageworx_product_fee_amount');
    }

    /**
     * @param string $mageworxProductFeeAmount
     * @return $this
     */
    public function setMageworxProductFeeAmount($mageworxProductFeeAmount)
    {
        $this->setData('mageworx_product_fee_amount', $mageworxProductFeeAmount);
        return $this;
    }

    /**
     * @return string|null
     */
    public function getBaseMageworxProductFeeAmount()
    {
        return $this->_get('base_mageworx_product_fee_amount');
    }

    /**
     * @param string $baseMageworxProductFeeAmount
     * @return $this
     */
    public function setBaseMageworxProductFeeAmount($baseMageworxProductFeeAmount)
    {
        $this->setData('base_mageworx_product_fee_amount', $baseMageworxProductFeeAmount);
        return $this;
    }

    /**
     * @return string|null
     */
    public function getMageworxProductFeeTaxAmount()
    {
        return $this->_get('mageworx_product_fee_tax_amount');
    }

    /**
     * @param string $mageworxProductFeeTaxAmount
     * @return $this
     */
    public function setMageworxProductFeeTaxAmount($mageworxProductFeeTaxAmount)
    {
        $this->setData('mageworx_product_fee_tax_amount', $mageworxProductFeeTaxAmount);
        return $this;
    }

    /**
     * @return string|null
     */
    public function getBaseMageworxProductFeeTaxAmount()
    {
        return $this->_get('base_mageworx_product_fee_tax_amount');
    }

    /**
     * @param string $baseMageworxProductFeeTaxAmount
     * @return $this
     */
    public function setBaseMageworxProductFeeTaxAmount($baseMageworxProductFeeTaxAmount)
    {
        $this->setData('base_mageworx_product_fee_tax_amount', $baseMageworxProductFeeTaxAmount);
        return $this;
    }

    /**
     * @return string|null
     */
    public function getMageworxProductFeeDetails()
    {
        return $this->_get('mageworx_product_fee_details');
    }

    /**
     * @param string $mageworxProductFeeDetails
     * @return $this
     */
    public function setMageworxProductFeeDetails($mageworxProductFeeDetails)
    {
        $this->setData('mageworx_product_fee_details', $mageworxProductFeeDetails);
        return $this;
    }

    /**
     * @return string|null
     */
    public function getMageworxProductFeeInvoiced()
    {
        return $this->_get('mageworx_product_fee_invoiced');
    }

    /**
     * @param string $mageworxProductFeeInvoiced
     * @return $this
     */
    public function setMageworxProductFeeInvoiced($mageworxProductFeeInvoiced)
    {
        $this->setData('mageworx_product_fee_invoiced', $mageworxProductFeeInvoiced);
        return $this;
    }

    /**
     * @return string|null
     */
    public function getBaseMageworxProductFeeInvoiced()
    {
        return $this->_get('base_mageworx_product_fee_invoiced');
    }

    /**
     * @param string $baseMageworxProductFeeInvoiced
     * @return $this
     */
    public function setBaseMageworxProductFeeInvoiced($baseMageworxProductFeeInvoiced)
    {
        $this->setData('base_mageworx_product_fee_invoiced', $baseMageworxProductFeeInvoiced);
        return $this;
    }

    /**
     * @return string|null
     */
    public function getMageworxProductFeeRefunded()
    {
        return $this->_get('mageworx_product_fee_refunded');
    }

    /**
     * @param string $mageworxProductFeeRefunded
     * @return $this
     */
    public function setMageworxProductFeeRefunded($mageworxProductFeeRefunded)
    {
        $this->setData('mageworx_product_fee_refunded', $mageworxProductFeeRefunded);
        return $this;
    }

    /**
     * @return string|null
     */
    public function getBaseMageworxProductFeeRefunded()
    {
        return $this->_get('base_mageworx_product_fee_refunded');
    }

    /**
     * @param string $baseMageworxProductFeeRefunded
     * @return $this
     */
    public function setBaseMageworxProductFeeRefunded($baseMageworxProductFeeRefunded)
    {
        $this->setData('base_mageworx_product_fee_refunded', $baseMageworxProductFeeRefunded);
        return $this;
    }

    /**
     * @return string|null
     */
    public function getMageworxProductFeeCancelled()
    {
        return $this->_get('mageworx_product_fee_cancelled');
    }

    /**
     * @param string $mageworxProductFeeCancelled
     * @return $this
     */
    public function setMageworxProductFeeCancelled($mageworxProductFeeCancelled)
    {
        $this->setData('mageworx_product_fee_cancelled', $mageworxProductFeeCancelled);
        return $this;
    }

    /**
     * @return string|null
     */
    public function getBaseMageworxProductFeeCancelled()
    {
        return $this->_get('base_mageworx_product_fee_cancelled');
    }

    /**
     * @param string $baseMageworxProductFeeCancelled
     * @return $this
     */
    public function setBaseMageworxProductFeeCancelled($baseMageworxProductFeeCancelled)
    {
        $this->setData('base_mageworx_product_fee_cancelled', $baseMageworxProductFeeCancelled);
        return $this;
    }

    /**
     * @return \Swissup\CheckoutFields\Api\Data\FieldDataInterface[]|null
     */
    public function getSwissupCheckoutFields()
    {
        return $this->_get('swissup_checkout_fields');
    }

    /**
     * @param \Swissup\CheckoutFields\Api\Data\FieldDataInterface[] $swissupCheckoutFields
     * @return $this
     */
    public function setSwissupCheckoutFields($swissupCheckoutFields)
    {
        $this->setData('swissup_checkout_fields', $swissupCheckoutFields);
        return $this;
    }
}
