<?php
namespace Magento\Sales\Api\Data;

/**
 * ExtensionInterface class for @see \Magento\Sales\Api\Data\OrderInterface
 */
interface OrderExtensionInterface extends \Magento\Framework\Api\ExtensionAttributesInterface
{
    /**
     * @return \Magento\Sales\Api\Data\ShippingAssignmentInterface[]|null
     */
    public function getShippingAssignments();

    /**
     * @param \Magento\Sales\Api\Data\ShippingAssignmentInterface[] $shippingAssignments
     * @return $this
     */
    public function setShippingAssignments($shippingAssignments);

    /**
     * @return \Magento\Payment\Api\Data\PaymentAdditionalInfoInterface[]|null
     */
    public function getPaymentAdditionalInfo();

    /**
     * @param \Magento\Payment\Api\Data\PaymentAdditionalInfoInterface[] $paymentAdditionalInfo
     * @return $this
     */
    public function setPaymentAdditionalInfo($paymentAdditionalInfo);

    /**
     * @return \Magento\GiftMessage\Api\Data\MessageInterface|null
     */
    public function getGiftMessage();

    /**
     * @param \Magento\GiftMessage\Api\Data\MessageInterface $giftMessage
     * @return $this
     */
    public function setGiftMessage(\Magento\GiftMessage\Api\Data\MessageInterface $giftMessage);

    /**
     * @return \Magento\Tax\Api\Data\OrderTaxDetailsAppliedTaxInterface[]|null
     */
    public function getAppliedTaxes();

    /**
     * @param \Magento\Tax\Api\Data\OrderTaxDetailsAppliedTaxInterface[] $appliedTaxes
     * @return $this
     */
    public function setAppliedTaxes($appliedTaxes);

    /**
     * @return \Magento\Tax\Api\Data\OrderTaxDetailsItemInterface[]|null
     */
    public function getItemAppliedTaxes();

    /**
     * @param \Magento\Tax\Api\Data\OrderTaxDetailsItemInterface[] $itemAppliedTaxes
     * @return $this
     */
    public function setItemAppliedTaxes($itemAppliedTaxes);

    /**
     * @return boolean|null
     */
    public function getConvertingFromQuote();

    /**
     * @param boolean $convertingFromQuote
     * @return $this
     */
    public function setConvertingFromQuote($convertingFromQuote);

    /**
     * @return string|null
     */
    public function getMageworxFeeAmount();

    /**
     * @param string $mageworxFeeAmount
     * @return $this
     */
    public function setMageworxFeeAmount($mageworxFeeAmount);

    /**
     * @return string|null
     */
    public function getBaseMageworxFeeAmount();

    /**
     * @param string $baseMageworxFeeAmount
     * @return $this
     */
    public function setBaseMageworxFeeAmount($baseMageworxFeeAmount);

    /**
     * @return string|null
     */
    public function getMageworxFeeTaxAmount();

    /**
     * @param string $mageworxFeeTaxAmount
     * @return $this
     */
    public function setMageworxFeeTaxAmount($mageworxFeeTaxAmount);

    /**
     * @return string|null
     */
    public function getBaseMageworxFeeTaxAmount();

    /**
     * @param string $baseMageworxFeeTaxAmount
     * @return $this
     */
    public function setBaseMageworxFeeTaxAmount($baseMageworxFeeTaxAmount);

    /**
     * @return string|null
     */
    public function getMageworxFeeDetails();

    /**
     * @param string $mageworxFeeDetails
     * @return $this
     */
    public function setMageworxFeeDetails($mageworxFeeDetails);

    /**
     * @return string|null
     */
    public function getMageworxFeeInvoiced();

    /**
     * @param string $mageworxFeeInvoiced
     * @return $this
     */
    public function setMageworxFeeInvoiced($mageworxFeeInvoiced);

    /**
     * @return string|null
     */
    public function getBaseMageworxFeeInvoiced();

    /**
     * @param string $baseMageworxFeeInvoiced
     * @return $this
     */
    public function setBaseMageworxFeeInvoiced($baseMageworxFeeInvoiced);

    /**
     * @return string|null
     */
    public function getMageworxFeeRefunded();

    /**
     * @param string $mageworxFeeRefunded
     * @return $this
     */
    public function setMageworxFeeRefunded($mageworxFeeRefunded);

    /**
     * @return string|null
     */
    public function getBaseMageworxFeeRefunded();

    /**
     * @param string $baseMageworxFeeRefunded
     * @return $this
     */
    public function setBaseMageworxFeeRefunded($baseMageworxFeeRefunded);

    /**
     * @return string|null
     */
    public function getMageworxFeeCancelled();

    /**
     * @param string $mageworxFeeCancelled
     * @return $this
     */
    public function setMageworxFeeCancelled($mageworxFeeCancelled);

    /**
     * @return string|null
     */
    public function getBaseMageworxFeeCancelled();

    /**
     * @param string $baseMageworxFeeCancelled
     * @return $this
     */
    public function setBaseMageworxFeeCancelled($baseMageworxFeeCancelled);

    /**
     * @return string|null
     */
    public function getMageworxProductFeeAmount();

    /**
     * @param string $mageworxProductFeeAmount
     * @return $this
     */
    public function setMageworxProductFeeAmount($mageworxProductFeeAmount);

    /**
     * @return string|null
     */
    public function getBaseMageworxProductFeeAmount();

    /**
     * @param string $baseMageworxProductFeeAmount
     * @return $this
     */
    public function setBaseMageworxProductFeeAmount($baseMageworxProductFeeAmount);

    /**
     * @return string|null
     */
    public function getMageworxProductFeeTaxAmount();

    /**
     * @param string $mageworxProductFeeTaxAmount
     * @return $this
     */
    public function setMageworxProductFeeTaxAmount($mageworxProductFeeTaxAmount);

    /**
     * @return string|null
     */
    public function getBaseMageworxProductFeeTaxAmount();

    /**
     * @param string $baseMageworxProductFeeTaxAmount
     * @return $this
     */
    public function setBaseMageworxProductFeeTaxAmount($baseMageworxProductFeeTaxAmount);

    /**
     * @return string|null
     */
    public function getMageworxProductFeeDetails();

    /**
     * @param string $mageworxProductFeeDetails
     * @return $this
     */
    public function setMageworxProductFeeDetails($mageworxProductFeeDetails);

    /**
     * @return string|null
     */
    public function getMageworxProductFeeInvoiced();

    /**
     * @param string $mageworxProductFeeInvoiced
     * @return $this
     */
    public function setMageworxProductFeeInvoiced($mageworxProductFeeInvoiced);

    /**
     * @return string|null
     */
    public function getBaseMageworxProductFeeInvoiced();

    /**
     * @param string $baseMageworxProductFeeInvoiced
     * @return $this
     */
    public function setBaseMageworxProductFeeInvoiced($baseMageworxProductFeeInvoiced);

    /**
     * @return string|null
     */
    public function getMageworxProductFeeRefunded();

    /**
     * @param string $mageworxProductFeeRefunded
     * @return $this
     */
    public function setMageworxProductFeeRefunded($mageworxProductFeeRefunded);

    /**
     * @return string|null
     */
    public function getBaseMageworxProductFeeRefunded();

    /**
     * @param string $baseMageworxProductFeeRefunded
     * @return $this
     */
    public function setBaseMageworxProductFeeRefunded($baseMageworxProductFeeRefunded);

    /**
     * @return string|null
     */
    public function getMageworxProductFeeCancelled();

    /**
     * @param string $mageworxProductFeeCancelled
     * @return $this
     */
    public function setMageworxProductFeeCancelled($mageworxProductFeeCancelled);

    /**
     * @return string|null
     */
    public function getBaseMageworxProductFeeCancelled();

    /**
     * @param string $baseMageworxProductFeeCancelled
     * @return $this
     */
    public function setBaseMageworxProductFeeCancelled($baseMageworxProductFeeCancelled);

    /**
     * @return \Swissup\CheckoutFields\Api\Data\FieldDataInterface[]|null
     */
    public function getSwissupCheckoutFields();

    /**
     * @param \Swissup\CheckoutFields\Api\Data\FieldDataInterface[] $swissupCheckoutFields
     * @return $this
     */
    public function setSwissupCheckoutFields($swissupCheckoutFields);
}
