define(['underscore','moment','uiLayout','Magento_Ui/js/grid/listing'],function(_,moment,layout,Listing){'use strict';var ONE_DAY=86400000;return Listing.extend({defaults:{recordTmpl:'ui/timeline/record',dateFormat:'YYYY-MM-DD HH:mm:ss',headerFormat:'ddd MM/DD',detailsFormat:'DD/MM/YYYY HH:mm:ss',scale:7,scaleStep:1,minScale:7,maxScale:28,minDays:28,displayMode:'timeline',displayModes:{timeline:{label:'Timeline',value:'timeline',template:'ui/timeline/timeline'}},viewConfig:{component:'Magento_Ui/js/timeline/timeline-view',name:'${ $.name }_view',model:'${ $.name }'},tracks:{scale:true},statefull:{scale:true},range:{}},initialize:function(){this._super().initView().updateRange();return this;},initConfig:function(){this._super();this.maxScale=Math.min(this.minDays,this.maxScale);this.minScale=Math.min(this.maxScale,this.minScale);return this;},initObservable:function(){this._super().observe.call(this.range,true,'hasToday');return this;},initView:function(){layout([this.viewConfig]);return this;},isActive:function(record){return Number(record.status)===1;},isUpcoming:function(record){return Number(record.status)===2;},isPermanent:function(record){return!this.getEndDate(record);},isToday:function(date){return moment().isSame(date,'day');},hasToday:function(){return this.range.hasToday;},getStartDate:function(record){return record['start_time'];},getEndDate:function(record){return record['end_time'];},getStartDelta:function(record){var start=this.createDate(this.getStartDate(record)),firstDay=this.range.firstDay;return start.diff(firstDay,'days',true);},getDaysLength:function(record){var start=this.createDate(this.getStartDate(record)),end=this.createDate(this.getEndDate(record));if(!end.isValid()){end=this.range.lastDay.endOf('day');}
return end.diff(start,'days',true);},createDate:function(dateStr){return moment(dateStr,this.dateFormat);},daysToWeeks:function(days){var weeks=days / 7;if(weeks%1){weeks=weeks.toFixed(1);}
return weeks;},updateRange:function(){var firstDay=this._getFirstDay(),lastDay=this._getLastDay(),totalDays=lastDay.diff(firstDay,'days'),days=[],i=-1;if(totalDays<this.minDays){totalDays+=this.minDays-totalDays-1;}
while(++i<=totalDays){days.push(+firstDay+ONE_DAY*i);}
return _.extend(this.range,{days:days,totalDays:totalDays,firstDay:firstDay,lastDay:moment(_.last(days)),hasToday:this.isToday(firstDay)});},_getDates:function(key){var dates=[];this.rows.forEach(function(record){if(record[key]){dates.push(this.createDate(record[key]));}},this);return dates;},_getFirstDay:function(){var dates=this._getDates('start_time'),first=moment.min(dates).subtract(1,'day'),today=moment();if(!first.isValid()||first<today){first=today;}
return first.startOf('day');},_getLastDay:function(){var startDates=this._getDates('start_time'),endDates=this._getDates('end_time'),last=moment.max(startDates.concat(endDates));return last.add(1,'day').startOf('day');},formatHeader:function(timestamp){return moment(timestamp).format(this.headerFormat);},formatDetails:function(date){return moment(date).format(this.detailsFormat);}});});