define(['jquery','underscore','ko','mageUtils','Magento_Catalog/js/product/query-builder','Magento_Customer/js/customer-data','jquery/jquery-storageapi'],function($,_,ko,utils,queryBuilder,customerData){'use strict';function getParsedDataFromServer(data){var result={};_.each(data.items,function(item){if(item.id){result[item.id]=item;}});return{items:result};}
function setLocalStorageItem(namespace,data){try{window.localStorage.setItem(namespace,JSON.stringify(data));}catch(e){console.warn('localStorage is unavailable - skipping local caching of product data');console.error(e);}}
return{name:'DataStorage',request:{},customerDataProvider:'product_data_storage',initialize:function(){if(!this.data){this.data=ko.observable({});}
this.initLocalStorage().initCustomerDataReloadListener().cachesDataFromLocalStorage().initDataListener().initProvideStorage().initProviderListener();return this;},initCustomerDataReloadListener:function(){$(document).on('customer-data-invalidate',this._flushProductStorage.bind(this));return this;},_flushProductStorage:function(event,sections){if(_.isEmpty(sections)||_.contains(sections,'product_data_storage')){this.localStorage.removeAll();}},initDataListener:function(){this.data.subscribe(this.dataHandler.bind(this));return this;},initProvideStorage:function(){this.providerHandler(customerData.get(this.customerDataProvider)());return this;},dataHandler:function(data){if(_.isEmpty(data)){this.localStorage.removeAll();}else{setLocalStorageItem(this.namespace,data);}},providerHandler:function(data){var currentData=utils.copy(this.data()),ids=_.keys(data.items);if(data.items&&ids.length){data=data.items;this.data(_.extend(data,currentData));}},setIds:function(currency,store,ids){if(!this.hasInCache(currency,store,ids)){this.loadDataFromServer(currency,store,ids);}else{this.data.valueHasMutated();}},getDataByIdentifiers:function(currency,store,productIdentifiers){var data={},dataCollection=this.data(),id;for(id in productIdentifiers){if(productIdentifiers.hasOwnProperty(id)){data[id]=dataCollection[id];}}
return data;},hasInCache:function(currency,store,ids){var data=this.data(),id;for(id in ids){if(!data.hasOwnProperty(id)||data[id]['currency_code']!==currency||~~data[id]['store_id']!==~~store){return false;}}
return true;},loadDataFromServer:function(currency,store,ids){var idsArray=_.keys(ids),prepareAjaxParams={'entity_id':idsArray.join(',')};if(this.request.sent&&this.hasIdsInSentRequest(ids)){return;}
this.request={sent:true,data:ids};this.updateRequestConfig.data=queryBuilder.buildQuery(prepareAjaxParams);this.updateRequestConfig.data['store_id']=store;this.updateRequestConfig.data['currency_code']=currency;$.ajax(this.updateRequestConfig).done(function(data){this.request={};this.providerHandler(getParsedDataFromServer(data));}.bind(this));},addDataFromPageCache:function(data){this.providerHandler(getParsedDataFromServer(data));},hasIdsInSentRequest:function(ids){var sentDataIds,currentDataIds;if(this.request.data){sentDataIds=_.keys(this.request.data);currentDataIds=_.keys(ids);_.each(currentDataIds,function(id){if(_.lastIndexOf(sentDataIds,id)===-1){return false;}});return true;}
return false;},initProviderListener:function(){customerData.get(this.customerDataProvider).subscribe(this.providerHandler.bind(this));return this;},cachesDataFromLocalStorage:function(){this.data(this.getDataFromLocalStorage());return this;},getDataFromLocalStorage:function(){return this.localStorage.get();},initLocalStorage:function(){this.localStorage=$.initNamespaceStorage(this.namespace).localStorage;return this;}};});