define(['jquery','underscore','mage/template','priceUtils','priceBox'],function($,_,mageTemplate,utils){'use strict';var globalOptions={optionConfig:null,productBundleSelector:'input.bundle.option, select.bundle.option, textarea.bundle.option',qtyFieldSelector:'input.qty',priceBoxSelector:'.price-box',optionHandlers:{},optionTemplate:'<%- data.label %>'+'<% if (data.finalPrice.value) { %>'+' +<%- data.finalPrice.formatted %>'+'<% } %>',controlContainer:'dd',priceFormat:{},isFixedPrice:false,optionTierPricesBlocksSelector:'#option-tier-prices-{1} [data-role="selection-tier-prices"]'};$.widget('mage.priceBundle',{options:globalOptions,_init:function initPriceBundle(){var form=this.element,options=$(this.options.productBundleSelector,form);options.trigger('change');},_create:function createPriceBundle(){var form=this.element,options=$(this.options.productBundleSelector,form),priceBox=$(this.options.priceBoxSelector,form),qty=$(this.options.qtyFieldSelector,form);if(priceBox.data('magePriceBox')&&priceBox.priceBox('option')&&priceBox.priceBox('option').priceConfig){if(priceBox.priceBox('option').priceConfig.optionTemplate){this._setOption('optionTemplate',priceBox.priceBox('option').priceConfig.optionTemplate);}
this._setOption('priceFormat',priceBox.priceBox('option').priceConfig.priceFormat);priceBox.priceBox('setDefault',this.options.optionConfig.prices);}
this._applyOptionNodeFix(options);options.on('change',this._onBundleOptionChanged.bind(this));qty.on('change',this._onQtyFieldChanged.bind(this));},_onBundleOptionChanged:function onBundleOptionChanged(event){var changes,bundleOption=$(event.target),priceBox=$(this.options.priceBoxSelector,this.element),handler=this.options.optionHandlers[bundleOption.data('role')];bundleOption.data('optionContainer',bundleOption.closest(this.options.controlContainer));bundleOption.data('qtyField',bundleOption.data('optionContainer').find(this.options.qtyFieldSelector));if(handler&&handler instanceof Function){changes=handler(bundleOption,this.options.optionConfig,this);}else{changes=defaultGetOptionValue(bundleOption,this.options.optionConfig);}
if(changes){priceBox.trigger('updatePrice',changes);}
this._displayTierPriceBlock(bundleOption);this.updateProductSummary();},_onQtyFieldChanged:function onQtyFieldChanged(event){var field=$(event.target),optionInstance,optionConfig;if(field.data('optionId')&&field.data('optionValueId')){optionInstance=field.data('option');optionConfig=this.options.optionConfig.options[field.data('optionId')].selections[field.data('optionValueId')];optionConfig.qty=field.val();optionInstance.trigger('change');}},_applyQtyFix:function applyQtyFix(){var config=this.options.optionConfig;if(config.isFixedPrice){_.each(config.options,function(option){_.each(option.selections,function(item){if(item.qty&&item.qty!==1){_.each(item.prices,function(price){price.amount /=item.qty;});}});});}},_applyOptionNodeFix:function applyOptionNodeFix(options){var config=this.options,format=config.priceFormat,template=config.optionTemplate;template=mageTemplate(template);options.filter('select').each(function(index,element){var $element=$(element),optionId=utils.findOptionId($element),optionConfig=config.optionConfig&&config.optionConfig.options[optionId].selections,value;$element.find('option').each(function(idx,option){var $option,optionValue,toTemplate,prices;$option=$(option);optionValue=$option.val();if(!optionValue&&optionValue!==0){return;}
toTemplate={data:{label:optionConfig[optionValue]&&optionConfig[optionValue].name}};prices=optionConfig[optionValue].prices;_.each(prices,function(price,type){value=+price.amount;value+=_.reduce(price.adjustments,function(sum,x){return sum+x;},0);toTemplate.data[type]={value:value,formatted:utils.formatPrice(value,format)};});$option.html(template(toTemplate));});});},_setOptions:function setOptions(options){$.extend(true,this.options,options);this._super(options);return this;},_displayTierPriceBlock:function(optionElement){var optionType=optionElement.prop('type'),optionId,optionValue,optionTierPricesElements;if(optionType==='select-one'){optionId=utils.findOptionId(optionElement[0]);optionValue=optionElement.val()||null;optionTierPricesElements=$(this.options.optionTierPricesBlocksSelector.replace('{1}',optionId));_.each(optionTierPricesElements,function(tierPriceElement){var selectionId=$(tierPriceElement).data('selection-id')+'';if(selectionId===optionValue){$(tierPriceElement).show();}else{$(tierPriceElement).hide();}});}},updateProductSummary:function updateProductSummary(){this.element.trigger('updateProductSummary',{config:this.options.optionConfig});}});return $.mage.priceBundle;function defaultGetOptionValue(element,config){var changes={},optionHash,tempChanges,qtyField,optionId=utils.findOptionId(element[0]),optionValue=element.val()||null,optionName=element.prop('name'),optionType=element.prop('type'),optionConfig=config.options[optionId].selections,optionQty=0,canQtyCustomize=false,selectedIds=config.selected;switch(optionType){case'radio':case'select-one':if(optionType==='radio'&&!element.is(':checked')){return null;}
qtyField=element.data('qtyField');qtyField.data('option',element);if(optionValue){optionQty=optionConfig[optionValue].qty||0;canQtyCustomize=optionConfig[optionValue].customQty==='1';toggleQtyField(qtyField,optionQty,optionId,optionValue,canQtyCustomize);tempChanges=utils.deepClone(optionConfig[optionValue].prices);tempChanges=applyTierPrice(tempChanges,optionQty,optionConfig[optionValue]);tempChanges=applyQty(tempChanges,optionQty);}else{tempChanges={};toggleQtyField(qtyField,'0',optionId,optionValue,false);}
optionHash='bundle-option-'+optionName;changes[optionHash]=tempChanges;selectedIds[optionId]=[optionValue];break;case'select-multiple':optionValue=_.compact(optionValue);_.each(optionConfig,function(row,optionValueCode){optionHash='bundle-option-'+optionName+'##'+optionValueCode;optionQty=row.qty||0;tempChanges=utils.deepClone(row.prices);tempChanges=applyTierPrice(tempChanges,optionQty,optionConfig);tempChanges=applyQty(tempChanges,optionQty);changes[optionHash]=_.contains(optionValue,optionValueCode)?tempChanges:{};});selectedIds[optionId]=optionValue||[];break;case'checkbox':optionHash='bundle-option-'+optionName+'##'+optionValue;optionQty=optionConfig[optionValue].qty||0;tempChanges=utils.deepClone(optionConfig[optionValue].prices);tempChanges=applyTierPrice(tempChanges,optionQty,optionConfig);tempChanges=applyQty(tempChanges,optionQty);changes[optionHash]=element.is(':checked')?tempChanges:{};selectedIds[optionId]=selectedIds[optionId]||[];if(!_.contains(selectedIds[optionId],optionValue)&&element.is(':checked')){selectedIds[optionId].push(optionValue);}else if(!element.is(':checked')){selectedIds[optionId]=_.without(selectedIds[optionId],optionValue);}
break;case'hidden':optionHash='bundle-option-'+optionName+'##'+optionValue;optionQty=optionConfig[optionValue].qty||0;canQtyCustomize=optionConfig[optionValue].customQty==='1';qtyField=element.data('qtyField');qtyField.data('option',element);toggleQtyField(qtyField,optionQty,optionId,optionValue,canQtyCustomize);tempChanges=utils.deepClone(optionConfig[optionValue].prices);tempChanges=applyTierPrice(tempChanges,optionQty,optionConfig);tempChanges=applyQty(tempChanges,optionQty);optionHash='bundle-option-'+optionName;changes[optionHash]=tempChanges;selectedIds[optionId]=[optionValue];break;}
return changes;}
function toggleQtyField(element,value,optionId,optionValueId,canEdit){element.val(value).data('optionId',optionId).data('optionValueId',optionValueId).attr('disabled',!canEdit);if(canEdit){element.removeClass('qty-disabled');}else{element.addClass('qty-disabled');}}
function applyQty(prices,qty){_.each(prices,function(everyPrice){everyPrice.amount*=qty;_.each(everyPrice.adjustments,function(el,index){everyPrice.adjustments[index]*=qty;});});return prices;}
function applyTierPrice(oneItemPrice,qty,optionConfig){var tiers=optionConfig.tierPrice,magicKey=_.keys(oneItemPrice)[0],tiersFirstKey=_.keys(optionConfig)[0],lowest=false;if(!tiers){tiers=optionConfig[tiersFirstKey].tierPrice;}
tiers.sort(function(a,b){return a['price_qty']-b['price_qty'];});_.each(tiers,function(tier,index){if(tier['price_qty']>qty){return;}
if(tier.prices[magicKey].amount<oneItemPrice[magicKey].amount){lowest=index;}});if(lowest!==false){oneItemPrice=utils.deepClone(tiers[lowest].prices);}
return oneItemPrice;}});