define(['jquery','underscore','uiComponent','uiRegistry','Magento_Checkout/js/model/quote','Magento_Customer/js/model/customer','Magento_Checkout/js/model/payment/method-list','Magento_Checkout/js/model/shipping-service','Swissup_Firecheckout/js/model/validator','Magento_Checkout/js/model/address-converter','Magento_Checkout/js/action/select-shipping-address','Magento_Checkout/js/action/select-billing-address','Swissup_Firecheckout/js/action/set-shipping-method','Swissup_Firecheckout/js/custom'],function($,_,Component,registry,quote,customer,paymentMethods,shippingService,validator,addressConverter,selectShippingAddress,selectBillingAddress,setShippingMethodAction){'use strict';return Component.extend({defaults:{plugins:{}},sameAsShippingObservers:[],initQuote:function(){quote.firecheckout={state:{savingShippingMethod:false,placeOrderPressed:false},memo:{shippingMethod:{},shippingAddress:{}}};},initialize:function(){this._super();this.initQuote();if(quote.isVirtual()){$('body').addClass('firecheckout-quote-virtual');}else{this.addShippingHandlers();}
quote.paymentMethod.subscribe(function(){validator.removeNotice('#co-payment-form');},this);this.initPlugins();},initPlugins:function(){_.each(this.plugins,function(el){if(el.pluginDisabled||!el.plugin){return;}
require([el.plugin],function(plugin){plugin.init.apply(plugin,el.params);});});},addShippingHandlers:function(){var debouncedSelectShippingAddress=_.debounce(function(address){var currentAddress=quote.shippingAddress();if(currentAddress.getCacheKey()!==address.getCacheKey()){return;}
selectShippingAddress(address);},2200);this.debouncedSaveShippingMethod=_.debounce(this.saveShippingMethod.bind(this),200);quote.shippingMethod.subscribe(function(){validator.removeNotice('#co-shipping-method-form');if(shippingService.isLoading()){return;}
this.applyShippingMethod(true);},this);shippingService.isLoading.subscribe(function(flag){if(flag){return;}
this.applyShippingMethod();},this);this.addSameAsShippingObservers();quote.paymentMethod.subscribe(function(method){this.toggleEqualAddressClassName(method);},this);if(!customer.isLoggedIn()||!customer.getShippingAddressList().length){registry.async('checkoutProvider')(function(checkoutProvider){checkoutProvider.on('shippingAddress',function(shippingAddressData){var shippingAddress=quote.shippingAddress(),addressData=addressConverter.formAddressDataToQuoteAddress(shippingAddressData),field;if(!shippingAddress){return;}
for(field in addressData){if(addressData.hasOwnProperty(field)&&shippingAddress.hasOwnProperty(field)&&typeof addressData[field]!='function'){shippingAddress[field]=addressData[field];}}
debouncedSelectShippingAddress(shippingAddress);});});}
quote.shippingAddress.subscribe(function(){var method=quote.paymentMethod(),sharedBillingAddress='checkout.steps.billing-step.payment.afterMethods.billing-address-form',billingAddressNames=[],billingNameForCurrentPayment;if(registry.get(sharedBillingAddress)){billingAddressNames.push(sharedBillingAddress);}else if(!method){_.each(paymentMethods(),function(paymentMethodData){billingAddressNames.push('checkout.steps.billing-step.payment.payments-list.'+
paymentMethodData.method+'-form');});}else{billingNameForCurrentPayment='checkout.steps.billing-step.payment.payments-list.'+
method.method+'-form';billingAddressNames.push(billingNameForCurrentPayment);if(!registry.get(billingNameForCurrentPayment)&&quote.shippingAddress()&&quote.shippingAddress().canUseForBilling()){selectBillingAddress(quote.shippingAddress());}}
_.each(billingAddressNames,function(name){registry.get(name,function(billingAddress){if(!billingAddress.isAddressSameAsShipping()){return;}
if(quote.shippingAddress()&&quote.shippingAddress().canUseForBilling()){selectBillingAddress(quote.shippingAddress());}else if(billingAddress.isAddressSameAsShipping()){billingAddress.isAddressSameAsShipping(false);}});});},this);},applyShippingMethod:function(force){if(!shippingService.getShippingRates()().length){quote.shippingMethod(null);}
this.debouncedSaveShippingMethod(force);},saveShippingMethod:function(force){var methodSent;if(quote.firecheckout.state.savingShippingMethod!==false){methodSent=quote.firecheckout.state.savingShippingMethod;if(!methodSent&&!quote.shippingMethod()){return;}
if(methodSent&&quote.shippingMethod()&&methodSent.method_code===quote.shippingMethod().method_code&&methodSent.amount===quote.shippingMethod().amount){return;}}
if(!force&&!this.shouldSaveShippingInformation()){this._log('SKIP',quote.shippingMethod());return;}
this._log('APPLY',quote.shippingMethod());quote.firecheckout.state.savingShippingMethod=quote.shippingMethod();setTimeout(function(){setShippingMethodAction().done(function(){var address;quote.firecheckout.state.savingShippingMethod=false;quote.firecheckout.memo.shippingMethod=quote.shippingMethod();address=quote.shippingAddress();quote.firecheckout.memo.shippingAddress={'countryId':address.countryId,'postcode':address.postcode,'region':address.region,'regionId':address.regionId,'vatId':address.vatId};}).fail(function(){quote.firecheckout.state.savingShippingMethod=false;});},50);},shouldSaveShippingInformation:function(){var memo=quote.firecheckout.memo,addressFields;if(!memo.shippingMethod&&!quote.shippingMethod()){return false;}
if(!memo.shippingMethod||!quote.shippingMethod()){return true;}
if(_.isObject(memo.shippingMethod)&&_.isEmpty(memo.shippingMethod)){if(quote.totals().shipping_amount==quote.shippingMethod().amount){return false;}}
if(memo.shippingMethod.amount!==quote.shippingMethod().amount){return true;}
addressFields=['countryId','postcode','region','regionId','vatId'];return addressFields.some(function(field){return memo.shippingAddress[field]!==quote.shippingAddress()[field];});},toggleEqualAddressClassName:function(method){registry.get('checkout.steps.billing-step.payment.afterMethods.billing-address-form',function(billingAddress){billingAddress.isAddressSameAsShipping.subscribe(function(flag){$('body').toggleClass('equal-billing-shipping',flag);});});method=method||quote.paymentMethod();if(!method){return;}
registry.get('checkout.steps.billing-step.payment.payments-list.'+method.method+'-form',function(billingAddress){var flag=billingAddress.isAddressSameAsShipping();$('body').toggleClass('equal-billing-shipping',flag);});return true;},addSameAsShippingObservers:function(){registry.get('checkout.steps.billing-step.payment.afterMethods.billing-address-form',function(billingAddress){billingAddress.isAddressSameAsShipping.subscribe(function(flag){$('body').toggleClass('equal-billing-shipping',flag);});});_.each(paymentMethods(),function(paymentMethodData){registry.get('checkout.steps.billing-step.payment.payments-list.'+paymentMethodData.method+'-form',function(billingAddress){billingAddress.isAddressSameAsShipping.subscribe(function(flag){$('body').toggleClass('equal-billing-shipping',flag);});});});},_log:function(title,data){var date;if(window.location.hash!=='#development'){return;}
date=new Date();console.log(date.getSeconds()+': '+title);console.log(data);}});});