/*!
* Tippy.js v2.5.4
* (c) 2017-2018 atomiks
* MIT
*/
(function(global,factory){typeof exports==='object'&&typeof module!=='undefined'?module.exports=factory():typeof define==='function'&&define.amd?define(factory):(global.tippy=factory());}(this,(function(){'use strict';var styles=".tippy-touch{cursor:pointer!important}.tippy-notransition{transition:none!important}.tippy-popper{max-width:350px;-webkit-perspective:700px;perspective:700px;z-index:9999;outline:0;transition-timing-function:cubic-bezier(.165,.84,.44,1);pointer-events:none;line-height:1.4}.tippy-popper[data-html]{max-width:96%;max-width:calc(100% - 20px)}.tippy-popper[x-placement^=top] .tippy-backdrop{border-radius:40% 40% 0 0}.tippy-popper[x-placement^=top] .tippy-roundarrow{bottom:-8px;-webkit-transform-origin:50% 0;transform-origin:50% 0}.tippy-popper[x-placement^=top] .tippy-roundarrow svg{position:absolute;left:0;-webkit-transform:rotate(180deg);transform:rotate(180deg)}.tippy-popper[x-placement^=top] .tippy-arrow{border-top:7px solid #333;border-right:7px solid transparent;border-left:7px solid transparent;bottom:-7px;margin:0 6px;-webkit-transform-origin:50% 0;transform-origin:50% 0}.tippy-popper[x-placement^=top] .tippy-backdrop{-webkit-transform-origin:0 90%;transform-origin:0 90%}.tippy-popper[x-placement^=top] .tippy-backdrop[data-state=visible]{-webkit-transform:scale(6) translate(-50%,25%);transform:scale(6) translate(-50%,25%);opacity:1}.tippy-popper[x-placement^=top] .tippy-backdrop[data-state=hidden]{-webkit-transform:scale(1) translate(-50%,25%);transform:scale(1) translate(-50%,25%);opacity:0}.tippy-popper[x-placement^=top] [data-animation=shift-toward][data-state=visible]{opacity:1;-webkit-transform:translateY(-10px);transform:translateY(-10px)}.tippy-popper[x-placement^=top] [data-animation=shift-toward][data-state=hidden]{opacity:0;-webkit-transform:translateY(-20px);transform:translateY(-20px)}.tippy-popper[x-placement^=top] [data-animation=perspective]{-webkit-transform-origin:bottom;transform-origin:bottom}.tippy-popper[x-placement^=top] [data-animation=perspective][data-state=visible]{opacity:1;-webkit-transform:translateY(-10px) rotateX(0);transform:translateY(-10px) rotateX(0)}.tippy-popper[x-placement^=top] [data-animation=perspective][data-state=hidden]{opacity:0;-webkit-transform:translateY(0) rotateX(90deg);transform:translateY(0) rotateX(90deg)}.tippy-popper[x-placement^=top] [data-animation=fade][data-state=visible]{opacity:1;-webkit-transform:translateY(-10px);transform:translateY(-10px)}.tippy-popper[x-placement^=top] [data-animation=fade][data-state=hidden]{opacity:0;-webkit-transform:translateY(-10px);transform:translateY(-10px)}.tippy-popper[x-placement^=top] [data-animation=shift-away][data-state=visible]{opacity:1;-webkit-transform:translateY(-10px);transform:translateY(-10px)}.tippy-popper[x-placement^=top] [data-animation=shift-away][data-state=hidden]{opacity:0;-webkit-transform:translateY(0);transform:translateY(0)}.tippy-popper[x-placement^=top] [data-animation=scale][data-state=visible]{opacity:1;-webkit-transform:translateY(-10px) scale(1);transform:translateY(-10px) scale(1)}.tippy-popper[x-placement^=top] [data-animation=scale][data-state=hidden]{opacity:0;-webkit-transform:translateY(0) scale(0);transform:translateY(0) scale(0)}.tippy-popper[x-placement^=bottom] .tippy-backdrop{border-radius:0 0 30% 30%}.tippy-popper[x-placement^=bottom] .tippy-roundarrow{top:-8px;-webkit-transform-origin:50% 100%;transform-origin:50% 100%}.tippy-popper[x-placement^=bottom] .tippy-roundarrow svg{position:absolute;left:0;-webkit-transform:rotate(0);transform:rotate(0)}.tippy-popper[x-placement^=bottom] .tippy-arrow{border-bottom:7px solid #333;border-right:7px solid transparent;border-left:7px solid transparent;top:-7px;margin:0 6px;-webkit-transform-origin:50% 100%;transform-origin:50% 100%}.tippy-popper[x-placement^=bottom] .tippy-backdrop{-webkit-transform-origin:0 -90%;transform-origin:0 -90%}.tippy-popper[x-placement^=bottom] .tippy-backdrop[data-state=visible]{-webkit-transform:scale(6) translate(-50%,-125%);transform:scale(6) translate(-50%,-125%);opacity:1}.tippy-popper[x-placement^=bottom] .tippy-backdrop[data-state=hidden]{-webkit-transform:scale(1) translate(-50%,-125%);transform:scale(1) translate(-50%,-125%);opacity:0}.tippy-popper[x-placement^=bottom] [data-animation=shift-toward][data-state=visible]{opacity:1;-webkit-transform:translateY(10px);transform:translateY(10px)}.tippy-popper[x-placement^=bottom] [data-animation=shift-toward][data-state=hidden]{opacity:0;-webkit-transform:translateY(20px);transform:translateY(20px)}.tippy-popper[x-placement^=bottom] [data-animation=perspective]{-webkit-transform-origin:top;transform-origin:top}.tippy-popper[x-placement^=bottom] [data-animation=perspective][data-state=visible]{opacity:1;-webkit-transform:translateY(10px) rotateX(0);transform:translateY(10px) rotateX(0)}.tippy-popper[x-placement^=bottom] [data-animation=perspective][data-state=hidden]{opacity:0;-webkit-transform:translateY(0) rotateX(-90deg);transform:translateY(0) rotateX(-90deg)}.tippy-popper[x-placement^=bottom] [data-animation=fade][data-state=visible]{opacity:1;-webkit-transform:translateY(10px);transform:translateY(10px)}.tippy-popper[x-placement^=bottom] [data-animation=fade][data-state=hidden]{opacity:0;-webkit-transform:translateY(10px);transform:translateY(10px)}.tippy-popper[x-placement^=bottom] [data-animation=shift-away][data-state=visible]{opacity:1;-webkit-transform:translateY(10px);transform:translateY(10px)}.tippy-popper[x-placement^=bottom] [data-animation=shift-away][data-state=hidden]{opacity:0;-webkit-transform:translateY(0);transform:translateY(0)}.tippy-popper[x-placement^=bottom] [data-animation=scale][data-state=visible]{opacity:1;-webkit-transform:translateY(10px) scale(1);transform:translateY(10px) scale(1)}.tippy-popper[x-placement^=bottom] [data-animation=scale][data-state=hidden]{opacity:0;-webkit-transform:translateY(0) scale(0);transform:translateY(0) scale(0)}.tippy-popper[x-placement^=left] .tippy-backdrop{border-radius:50% 0 0 50%}.tippy-popper[x-placement^=left] .tippy-roundarrow{right:-16px;-webkit-transform-origin:33.33333333% 50%;transform-origin:33.33333333% 50%}.tippy-popper[x-placement^=left] .tippy-roundarrow svg{position:absolute;left:0;-webkit-transform:rotate(90deg);transform:rotate(90deg)}.tippy-popper[x-placement^=left] .tippy-arrow{border-left:7px solid #333;border-top:7px solid transparent;border-bottom:7px solid transparent;right:-7px;margin:3px 0;-webkit-transform-origin:0 50%;transform-origin:0 50%}.tippy-popper[x-placement^=left] .tippy-backdrop{-webkit-transform-origin:100% 0;transform-origin:100% 0}.tippy-popper[x-placement^=left] .tippy-backdrop[data-state=visible]{-webkit-transform:scale(6) translate(40%,-50%);transform:scale(6) translate(40%,-50%);opacity:1}.tippy-popper[x-placement^=left] .tippy-backdrop[data-state=hidden]{-webkit-transform:scale(1.5) translate(40%,-50%);transform:scale(1.5) translate(40%,-50%);opacity:0}.tippy-popper[x-placement^=left] [data-animation=shift-toward][data-state=visible]{opacity:1;-webkit-transform:translateX(-10px);transform:translateX(-10px)}.tippy-popper[x-placement^=left] [data-animation=shift-toward][data-state=hidden]{opacity:0;-webkit-transform:translateX(-20px);transform:translateX(-20px)}.tippy-popper[x-placement^=left] [data-animation=perspective]{-webkit-transform-origin:right;transform-origin:right}.tippy-popper[x-placement^=left] [data-animation=perspective][data-state=visible]{opacity:1;-webkit-transform:translateX(-10px) rotateY(0);transform:translateX(-10px) rotateY(0)}.tippy-popper[x-placement^=left] [data-animation=perspective][data-state=hidden]{opacity:0;-webkit-transform:translateX(0) rotateY(-90deg);transform:translateX(0) rotateY(-90deg)}.tippy-popper[x-placement^=left] [data-animation=fade][data-state=visible]{opacity:1;-webkit-transform:translateX(-10px);transform:translateX(-10px)}.tippy-popper[x-placement^=left] [data-animation=fade][data-state=hidden]{opacity:0;-webkit-transform:translateX(-10px);transform:translateX(-10px)}.tippy-popper[x-placement^=left] [data-animation=shift-away][data-state=visible]{opacity:1;-webkit-transform:translateX(-10px);transform:translateX(-10px)}.tippy-popper[x-placement^=left] [data-animation=shift-away][data-state=hidden]{opacity:0;-webkit-transform:translateX(0);transform:translateX(0)}.tippy-popper[x-placement^=left] [data-animation=scale][data-state=visible]{opacity:1;-webkit-transform:translateX(-10px) scale(1);transform:translateX(-10px) scale(1)}.tippy-popper[x-placement^=left] [data-animation=scale][data-state=hidden]{opacity:0;-webkit-transform:translateX(0) scale(0);transform:translateX(0) scale(0)}.tippy-popper[x-placement^=right] .tippy-backdrop{border-radius:0 50% 50% 0}.tippy-popper[x-placement^=right] .tippy-roundarrow{left:-16px;-webkit-transform-origin:66.66666666% 50%;transform-origin:66.66666666% 50%}.tippy-popper[x-placement^=right] .tippy-roundarrow svg{position:absolute;left:0;-webkit-transform:rotate(-90deg);transform:rotate(-90deg)}.tippy-popper[x-placement^=right] .tippy-arrow{border-right:7px solid #333;border-top:7px solid transparent;border-bottom:7px solid transparent;left:-7px;margin:3px 0;-webkit-transform-origin:100% 50%;transform-origin:100% 50%}.tippy-popper[x-placement^=right] .tippy-backdrop{-webkit-transform-origin:-100% 0;transform-origin:-100% 0}.tippy-popper[x-placement^=right] .tippy-backdrop[data-state=visible]{-webkit-transform:scale(6) translate(-140%,-50%);transform:scale(6) translate(-140%,-50%);opacity:1}.tippy-popper[x-placement^=right] .tippy-backdrop[data-state=hidden]{-webkit-transform:scale(1.5) translate(-140%,-50%);transform:scale(1.5) translate(-140%,-50%);opacity:0}.tippy-popper[x-placement^=right] [data-animation=shift-toward][data-state=visible]{opacity:1;-webkit-transform:translateX(10px);transform:translateX(10px)}.tippy-popper[x-placement^=right] [data-animation=shift-toward][data-state=hidden]{opacity:0;-webkit-transform:translateX(20px);transform:translateX(20px)}.tippy-popper[x-placement^=right] [data-animation=perspective]{-webkit-transform-origin:left;transform-origin:left}.tippy-popper[x-placement^=right] [data-animation=perspective][data-state=visible]{opacity:1;-webkit-transform:translateX(10px) rotateY(0);transform:translateX(10px) rotateY(0)}.tippy-popper[x-placement^=right] [data-animation=perspective][data-state=hidden]{opacity:0;-webkit-transform:translateX(0) rotateY(90deg);transform:translateX(0) rotateY(90deg)}.tippy-popper[x-placement^=right] [data-animation=fade][data-state=visible]{opacity:1;-webkit-transform:translateX(10px);transform:translateX(10px)}.tippy-popper[x-placement^=right] [data-animation=fade][data-state=hidden]{opacity:0;-webkit-transform:translateX(10px);transform:translateX(10px)}.tippy-popper[x-placement^=right] [data-animation=shift-away][data-state=visible]{opacity:1;-webkit-transform:translateX(10px);transform:translateX(10px)}.tippy-popper[x-placement^=right] [data-animation=shift-away][data-state=hidden]{opacity:0;-webkit-transform:translateX(0);transform:translateX(0)}.tippy-popper[x-placement^=right] [data-animation=scale][data-state=visible]{opacity:1;-webkit-transform:translateX(10px) scale(1);transform:translateX(10px) scale(1)}.tippy-popper[x-placement^=right] [data-animation=scale][data-state=hidden]{opacity:0;-webkit-transform:translateX(0) scale(0);transform:translateX(0) scale(0)}.tippy-tooltip{position:relative;color:#fff;border-radius:4px;font-size:.9rem;padding:.3rem .6rem;text-align:center;will-change:transform;-webkit-font-smoothing:antialiased;-moz-osx-font-smoothing:grayscale;background-color:#333}.tippy-tooltip[data-size=small]{padding:.2rem .4rem;font-size:.75rem}.tippy-tooltip[data-size=large]{padding:.4rem .8rem;font-size:1rem}.tippy-tooltip[data-animatefill]{overflow:hidden;background-color:transparent}.tippy-tooltip[data-animatefill] .tippy-content{transition:-webkit-clip-path cubic-bezier(.46,.1,.52,.98);transition:clip-path cubic-bezier(.46,.1,.52,.98);transition:clip-path cubic-bezier(.46,.1,.52,.98),-webkit-clip-path cubic-bezier(.46,.1,.52,.98)}.tippy-tooltip[data-interactive],.tippy-tooltip[data-interactive] path{pointer-events:auto}.tippy-tooltip[data-inertia][data-state=visible]{transition-timing-function:cubic-bezier(.53,2,.36,.85)}.tippy-tooltip[data-inertia][data-state=hidden]{transition-timing-function:ease}.tippy-arrow,.tippy-roundarrow{position:absolute;width:0;height:0}.tippy-roundarrow{width:24px;height:8px;fill:#333;pointer-events:none}.tippy-backdrop{position:absolute;will-change:transform;background-color:#333;border-radius:50%;width:26%;left:50%;top:50%;z-index:-1;transition:all cubic-bezier(.46,.1,.52,.98);-webkit-backface-visibility:hidden;backface-visibility:hidden}.tippy-backdrop:after{content:\"\";float:left;padding-top:100%}body:not(.tippy-touch) .tippy-tooltip[data-animatefill][data-state=visible] .tippy-content{-webkit-clip-path:ellipse(100% 100% at 50% 50%);clip-path:ellipse(100% 100% at 50% 50%)}body:not(.tippy-touch) .tippy-tooltip[data-animatefill][data-state=hidden] .tippy-content{-webkit-clip-path:ellipse(5% 50% at 50% 50%);clip-path:ellipse(5% 50% at 50% 50%)}body:not(.tippy-touch) .tippy-popper[x-placement=right] .tippy-tooltip[data-animatefill][data-state=visible] .tippy-content{-webkit-clip-path:ellipse(135% 100% at 0 50%);clip-path:ellipse(135% 100% at 0 50%)}body:not(.tippy-touch) .tippy-popper[x-placement=right] .tippy-tooltip[data-animatefill][data-state=hidden] .tippy-content{-webkit-clip-path:ellipse(40% 100% at 0 50%);clip-path:ellipse(40% 100% at 0 50%)}body:not(.tippy-touch) .tippy-popper[x-placement=left] .tippy-tooltip[data-animatefill][data-state=visible] .tippy-content{-webkit-clip-path:ellipse(135% 100% at 100% 50%);clip-path:ellipse(135% 100% at 100% 50%)}body:not(.tippy-touch) .tippy-popper[x-placement=left] .tippy-tooltip[data-animatefill][data-state=hidden] .tippy-content{-webkit-clip-path:ellipse(40% 100% at 100% 50%);clip-path:ellipse(40% 100% at 100% 50%)}@media (max-width:360px){.tippy-popper{max-width:96%;max-width:calc(100% - 20px)}}";var version="2.5.4";var isBrowser=typeof window!=='undefined';var isIE=isBrowser&&/MSIE |Trident\//.test(navigator.userAgent);var browser={};if(isBrowser){browser.supported='requestAnimationFrame'in window;browser.supportsTouch='ontouchstart'in window;browser.usingTouch=false;browser.dynamicInputDetection=true;browser.iOS=/iPhone|iPad|iPod/.test(navigator.platform)&&!window.MSStream;browser.onUserInputChange=function(){};}
var selectors={POPPER:'.tippy-popper',TOOLTIP:'.tippy-tooltip',CONTENT:'.tippy-content',BACKDROP:'.tippy-backdrop',ARROW:'.tippy-arrow',ROUND_ARROW:'.tippy-roundarrow',REFERENCE:'[data-tippy]'};var defaults={placement:'top',livePlacement:true,trigger:'mouseenter focus',animation:'shift-away',html:false,animateFill:true,arrow:false,delay:0,duration:[350,300],interactive:false,interactiveBorder:2,theme:'dark',size:'regular',distance:10,offset:0,hideOnClick:true,multiple:false,followCursor:false,inertia:false,updateDuration:350,sticky:false,appendTo:function appendTo(){return document.body;},zIndex:9999,touchHold:false,performance:false,dynamicTitle:false,flip:true,flipBehavior:'flip',arrowType:'sharp',arrowTransform:'',maxWidth:'',target:null,allowTitleHTML:true,popperOptions:{},createPopperInstanceOnInit:false,onShow:function onShow(){},onShown:function onShown(){},onHide:function onHide(){},onHidden:function onHidden(){}};var defaultsKeys=browser.supported&&Object.keys(defaults);function isObjectLiteral(value){return{}.toString.call(value)==='[object Object]';}
function toArray(value){return[].slice.call(value);}
function getArrayOfElements(selector){if(selector instanceof Element||isObjectLiteral(selector)){return[selector];}
if(selector instanceof NodeList){return toArray(selector);}
if(Array.isArray(selector)){return selector;}
try{return toArray(document.querySelectorAll(selector));}catch(_){return[];}}
function polyfillVirtualReferenceProps(reference){reference.refObj=true;reference.attributes=reference.attributes||{};reference.setAttribute=function(key,val){reference.attributes[key]=val;};reference.getAttribute=function(key){return reference.attributes[key];};reference.removeAttribute=function(key){delete reference.attributes[key];};reference.hasAttribute=function(key){return key in reference.attributes;};reference.addEventListener=function(){};reference.removeEventListener=function(){};reference.classList={classNames:{},add:function add(key){return reference.classList.classNames[key]=true;},remove:function remove(key){delete reference.classList.classNames[key];return true;},contains:function contains(key){return key in reference.classList.classNames;}};}
function prefix(property){var prefixes=['','webkit'];var upperProp=property.charAt(0).toUpperCase()+property.slice(1);for(var i=0;i<prefixes.length;i++){var _prefix=prefixes[i];var prefixedProp=_prefix?_prefix+upperProp:property;if(typeof document.body.style[prefixedProp]!=='undefined'){return prefixedProp;}}
return null;}
function div(){return document.createElement('div');}
function createPopperElement(id,title,options){var popper=div();popper.setAttribute('class','tippy-popper');popper.setAttribute('role','tooltip');popper.setAttribute('id','tippy-'+id);popper.style.zIndex=options.zIndex;popper.style.maxWidth=options.maxWidth;var tooltip=div();tooltip.setAttribute('class','tippy-tooltip');tooltip.setAttribute('data-size',options.size);tooltip.setAttribute('data-animation',options.animation);tooltip.setAttribute('data-state','hidden');options.theme.split(' ').forEach(function(t){tooltip.classList.add(t+'-theme');});var content=div();content.setAttribute('class','tippy-content');if(options.arrow){var arrow=div();arrow.style[prefix('transform')]=options.arrowTransform;if(options.arrowType==='round'){arrow.classList.add('tippy-roundarrow');arrow.innerHTML='<svg viewBox="0 0 24 8" xmlns="http://www.w3.org/2000/svg"><path d="M3 8s2.021-.015 5.253-4.218C9.584 2.051 10.797 1.007 12 1c1.203-.007 2.416 1.035 3.761 2.782C19.012 8.005 21 8 21 8H3z"/></svg>';}else{arrow.classList.add('tippy-arrow');}
tooltip.appendChild(arrow);}
if(options.animateFill){tooltip.setAttribute('data-animatefill','');var backdrop=div();backdrop.classList.add('tippy-backdrop');backdrop.setAttribute('data-state','hidden');tooltip.appendChild(backdrop);}
if(options.inertia){tooltip.setAttribute('data-inertia','');}
if(options.interactive){tooltip.setAttribute('data-interactive','');}
var html=options.html;if(html){var templateId=void 0;if(html instanceof Element){content.appendChild(html);templateId='#'+(html.id||'tippy-html-template');}else{content[true&&'innerHTML']=document.querySelector(html)[true&&'innerHTML'];templateId=html;}
popper.setAttribute('data-html','');tooltip.setAttribute('data-template-id',templateId);if(options.interactive){popper.setAttribute('tabindex','-1');}}else{content[options.allowTitleHTML?'innerHTML':'textContent']=title;}
tooltip.appendChild(content);popper.appendChild(tooltip);return popper;}
function createTrigger(eventType,reference,handlers,options){var onTrigger=handlers.onTrigger,onMouseLeave=handlers.onMouseLeave,onBlur=handlers.onBlur,onDelegateShow=handlers.onDelegateShow,onDelegateHide=handlers.onDelegateHide;var listeners=[];if(eventType==='manual')return listeners;var on=function on(eventType,handler){reference.addEventListener(eventType,handler);listeners.push({event:eventType,handler:handler});};if(!options.target){on(eventType,onTrigger);if(browser.supportsTouch&&options.touchHold){on('touchstart',onTrigger);on('touchend',onMouseLeave);}
if(eventType==='mouseenter'){on('mouseleave',onMouseLeave);}
if(eventType==='focus'){on(isIE?'focusout':'blur',onBlur);}}else{if(browser.supportsTouch&&options.touchHold){on('touchstart',onDelegateShow);on('touchend',onDelegateHide);}
if(eventType==='mouseenter'){on('mouseover',onDelegateShow);on('mouseout',onDelegateHide);}
if(eventType==='focus'){on('focusin',onDelegateShow);on('focusout',onDelegateHide);}
if(eventType==='click'){on('click',onDelegateShow);}}
return listeners;}
var classCallCheck=function(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function");}};var createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor);}}
return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor;};}();var _extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key];}}}
return target;};function getIndividualOptions(reference,instanceOptions){var options=defaultsKeys.reduce(function(acc,key){var val=reference.getAttribute('data-tippy-'+key.toLowerCase())||instanceOptions[key];if(val==='false')val=false;if(val==='true')val=true;if(isFinite(val)&&!isNaN(parseFloat(val))){val=parseFloat(val);}
if(key!=='target'&&typeof val==='string'&&val.trim().charAt(0)==='['){val=JSON.parse(val);}
acc[key]=val;return acc;},{});return _extends({},instanceOptions,options);}
function evaluateOptions(reference,options){if(options.arrow){options.animateFill=false;}
if(options.appendTo&&typeof options.appendTo==='function'){options.appendTo=options.appendTo();}
if(typeof options.html==='function'){options.html=options.html(reference);}
return options;}
function getInnerElements(popper){var select=function select(s){return popper.querySelector(s);};return{tooltip:select(selectors.TOOLTIP),backdrop:select(selectors.BACKDROP),content:select(selectors.CONTENT),arrow:select(selectors.ARROW)||select(selectors.ROUND_ARROW)};}
function removeTitle(el){var title=el.getAttribute('title');if(title){el.setAttribute('data-original-title',title);}
el.removeAttribute('title');}
var isBrowser$1=typeof window!=='undefined'&&typeof document!=='undefined';var longerTimeoutBrowsers=['Edge','Trident','Firefox'];var timeoutDuration=0;for(var i=0;i<longerTimeoutBrowsers.length;i+=1){if(isBrowser$1&&navigator.userAgent.indexOf(longerTimeoutBrowsers[i])>=0){timeoutDuration=1;break;}}
function microtaskDebounce(fn){var called=false;return function(){if(called){return;}
called=true;window.Promise.resolve().then(function(){called=false;fn();});};}
function taskDebounce(fn){var scheduled=false;return function(){if(!scheduled){scheduled=true;setTimeout(function(){scheduled=false;fn();},timeoutDuration);}};}
var supportsMicroTasks=isBrowser$1&&window.Promise;var debounce=supportsMicroTasks?microtaskDebounce:taskDebounce;function isFunction(functionToCheck){var getType={};return functionToCheck&&getType.toString.call(functionToCheck)==='[object Function]';}
function getStyleComputedProperty(element,property){if(element.nodeType!==1){return[];}
var css=getComputedStyle(element,null);return property?css[property]:css;}
function getParentNode(element){if(element.nodeName==='HTML'){return element;}
return element.parentNode||element.host;}
function getScrollParent(element){if(!element){return document.body;}
switch(element.nodeName){case'HTML':case'BODY':return element.ownerDocument.body;case'#document':return element.body;}
var _getStyleComputedProp=getStyleComputedProperty(element),overflow=_getStyleComputedProp.overflow,overflowX=_getStyleComputedProp.overflowX,overflowY=_getStyleComputedProp.overflowY;if(/(auto|scroll|overlay)/.test(overflow+overflowY+overflowX)){return element;}
return getScrollParent(getParentNode(element));}
var isIE11=isBrowser$1&&!!(window.MSInputMethodContext&&document.documentMode);var isIE10=isBrowser$1&&/MSIE 10/.test(navigator.userAgent);function isIE$1(version){if(version===11){return isIE11;}
if(version===10){return isIE10;}
return isIE11||isIE10;}
function getOffsetParent(element){if(!element){return document.documentElement;}
var noOffsetParent=isIE$1(10)?document.body:null;var offsetParent=element.offsetParent;while(offsetParent===noOffsetParent&&element.nextElementSibling){offsetParent=(element=element.nextElementSibling).offsetParent;}
var nodeName=offsetParent&&offsetParent.nodeName;if(!nodeName||nodeName==='BODY'||nodeName==='HTML'){return element?element.ownerDocument.documentElement:document.documentElement;}
if(['TD','TABLE'].indexOf(offsetParent.nodeName)!==-1&&getStyleComputedProperty(offsetParent,'position')==='static'){return getOffsetParent(offsetParent);}
return offsetParent;}
function isOffsetContainer(element){var nodeName=element.nodeName;if(nodeName==='BODY'){return false;}
return nodeName==='HTML'||getOffsetParent(element.firstElementChild)===element;}
function getRoot(node){if(node.parentNode!==null){return getRoot(node.parentNode);}
return node;}
function findCommonOffsetParent(element1,element2){if(!element1||!element1.nodeType||!element2||!element2.nodeType){return document.documentElement;}
var order=element1.compareDocumentPosition(element2)&Node.DOCUMENT_POSITION_FOLLOWING;var start=order?element1:element2;var end=order?element2:element1;var range=document.createRange();range.setStart(start,0);range.setEnd(end,0);var commonAncestorContainer=range.commonAncestorContainer;if(element1!==commonAncestorContainer&&element2!==commonAncestorContainer||start.contains(end)){if(isOffsetContainer(commonAncestorContainer)){return commonAncestorContainer;}
return getOffsetParent(commonAncestorContainer);}
var element1root=getRoot(element1);if(element1root.host){return findCommonOffsetParent(element1root.host,element2);}else{return findCommonOffsetParent(element1,getRoot(element2).host);}}
function getScroll(element){var side=arguments.length>1&&arguments[1]!==undefined?arguments[1]:'top';var upperSide=side==='top'?'scrollTop':'scrollLeft';var nodeName=element.nodeName;if(nodeName==='BODY'||nodeName==='HTML'){var html=element.ownerDocument.documentElement;var scrollingElement=element.ownerDocument.scrollingElement||html;return scrollingElement[upperSide];}
return element[upperSide];}
function includeScroll(rect,element){var subtract=arguments.length>2&&arguments[2]!==undefined?arguments[2]:false;var scrollTop=getScroll(element,'top');var scrollLeft=getScroll(element,'left');var modifier=subtract?-1:1;rect.top+=scrollTop*modifier;rect.bottom+=scrollTop*modifier;rect.left+=scrollLeft*modifier;rect.right+=scrollLeft*modifier;return rect;}
function getBordersSize(styles,axis){var sideA=axis==='x'?'Left':'Top';var sideB=sideA==='Left'?'Right':'Bottom';return parseFloat(styles['border'+sideA+'Width'],10)+parseFloat(styles['border'+sideB+'Width'],10);}
function getSize(axis,body,html,computedStyle){return Math.max(body['offset'+axis],body['scroll'+axis],html['client'+axis],html['offset'+axis],html['scroll'+axis],isIE$1(10)?html['offset'+axis]+computedStyle['margin'+(axis==='Height'?'Top':'Left')]+computedStyle['margin'+(axis==='Height'?'Bottom':'Right')]:0);}
function getWindowSizes(){var body=document.body;var html=document.documentElement;var computedStyle=isIE$1(10)&&getComputedStyle(html);return{height:getSize('Height',body,html,computedStyle),width:getSize('Width',body,html,computedStyle)};}
var classCallCheck$1=function classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function");}};var createClass$1=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor);}}
return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor;};}();var defineProperty$1=function defineProperty(obj,key,value){if(key in obj){Object.defineProperty(obj,key,{value:value,enumerable:true,configurable:true,writable:true});}else{obj[key]=value;}
return obj;};var _extends$1=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key];}}}
return target;};function getClientRect(offsets){return _extends$1({},offsets,{right:offsets.left+offsets.width,bottom:offsets.top+offsets.height});}
function getBoundingClientRect(element){var rect={};try{if(isIE$1(10)){rect=element.getBoundingClientRect();var scrollTop=getScroll(element,'top');var scrollLeft=getScroll(element,'left');rect.top+=scrollTop;rect.left+=scrollLeft;rect.bottom+=scrollTop;rect.right+=scrollLeft;}else{rect=element.getBoundingClientRect();}}catch(e){}
var result={left:rect.left,top:rect.top,width:rect.right-rect.left,height:rect.bottom-rect.top};var sizes=element.nodeName==='HTML'?getWindowSizes():{};var width=sizes.width||element.clientWidth||result.right-result.left;var height=sizes.height||element.clientHeight||result.bottom-result.top;var horizScrollbar=element.offsetWidth-width;var vertScrollbar=element.offsetHeight-height;if(horizScrollbar||vertScrollbar){var styles=getStyleComputedProperty(element);horizScrollbar-=getBordersSize(styles,'x');vertScrollbar-=getBordersSize(styles,'y');result.width-=horizScrollbar;result.height-=vertScrollbar;}
return getClientRect(result);}
function getOffsetRectRelativeToArbitraryNode(children,parent){var fixedPosition=arguments.length>2&&arguments[2]!==undefined?arguments[2]:false;var isIE10=isIE$1(10);var isHTML=parent.nodeName==='HTML';var childrenRect=getBoundingClientRect(children);var parentRect=getBoundingClientRect(parent);var scrollParent=getScrollParent(children);var styles=getStyleComputedProperty(parent);var borderTopWidth=parseFloat(styles.borderTopWidth,10);var borderLeftWidth=parseFloat(styles.borderLeftWidth,10);if(fixedPosition&&parent.nodeName==='HTML'){parentRect.top=Math.max(parentRect.top,0);parentRect.left=Math.max(parentRect.left,0);}
var offsets=getClientRect({top:childrenRect.top-parentRect.top-borderTopWidth,left:childrenRect.left-parentRect.left-borderLeftWidth,width:childrenRect.width,height:childrenRect.height});offsets.marginTop=0;offsets.marginLeft=0;if(!isIE10&&isHTML){var marginTop=parseFloat(styles.marginTop,10);var marginLeft=parseFloat(styles.marginLeft,10);offsets.top-=borderTopWidth-marginTop;offsets.bottom-=borderTopWidth-marginTop;offsets.left-=borderLeftWidth-marginLeft;offsets.right-=borderLeftWidth-marginLeft;offsets.marginTop=marginTop;offsets.marginLeft=marginLeft;}
if(isIE10&&!fixedPosition?parent.contains(scrollParent):parent===scrollParent&&scrollParent.nodeName!=='BODY'){offsets=includeScroll(offsets,parent);}
return offsets;}
function getViewportOffsetRectRelativeToArtbitraryNode(element){var excludeScroll=arguments.length>1&&arguments[1]!==undefined?arguments[1]:false;var html=element.ownerDocument.documentElement;var relativeOffset=getOffsetRectRelativeToArbitraryNode(element,html);var width=Math.max(html.clientWidth,window.innerWidth||0);var height=Math.max(html.clientHeight,window.innerHeight||0);var scrollTop=!excludeScroll?getScroll(html):0;var scrollLeft=!excludeScroll?getScroll(html,'left'):0;var offset={top:scrollTop-relativeOffset.top+relativeOffset.marginTop,left:scrollLeft-relativeOffset.left+relativeOffset.marginLeft,width:width,height:height};return getClientRect(offset);}
function isFixed(element){var nodeName=element.nodeName;if(nodeName==='BODY'||nodeName==='HTML'){return false;}
if(getStyleComputedProperty(element,'position')==='fixed'){return true;}
return isFixed(getParentNode(element));}
function getFixedPositionOffsetParent(element){if(!element||!element.parentElement||isIE$1()){return document.documentElement;}
var el=element.parentElement;while(el&&getStyleComputedProperty(el,'transform')==='none'){el=el.parentElement;}
return el||document.documentElement;}
function getBoundaries(popper,reference,padding,boundariesElement){var fixedPosition=arguments.length>4&&arguments[4]!==undefined?arguments[4]:false;var boundaries={top:0,left:0};var offsetParent=fixedPosition?getFixedPositionOffsetParent(popper):findCommonOffsetParent(popper,reference);if(boundariesElement==='viewport'){boundaries=getViewportOffsetRectRelativeToArtbitraryNode(offsetParent,fixedPosition);}else{var boundariesNode=void 0;if(boundariesElement==='scrollParent'){boundariesNode=getScrollParent(getParentNode(reference));if(boundariesNode.nodeName==='BODY'){boundariesNode=popper.ownerDocument.documentElement;}}else if(boundariesElement==='window'){boundariesNode=popper.ownerDocument.documentElement;}else{boundariesNode=boundariesElement;}
var offsets=getOffsetRectRelativeToArbitraryNode(boundariesNode,offsetParent,fixedPosition);if(boundariesNode.nodeName==='HTML'&&!isFixed(offsetParent)){var _getWindowSizes=getWindowSizes(),height=_getWindowSizes.height,width=_getWindowSizes.width;boundaries.top+=offsets.top-offsets.marginTop;boundaries.bottom=height+offsets.top;boundaries.left+=offsets.left-offsets.marginLeft;boundaries.right=width+offsets.left;}else{boundaries=offsets;}}
boundaries.left+=padding;boundaries.top+=padding;boundaries.right-=padding;boundaries.bottom-=padding;return boundaries;}
function getArea(_ref){var width=_ref.width,height=_ref.height;return width*height;}
function computeAutoPlacement(placement,refRect,popper,reference,boundariesElement){var padding=arguments.length>5&&arguments[5]!==undefined?arguments[5]:0;if(placement.indexOf('auto')===-1){return placement;}
var boundaries=getBoundaries(popper,reference,padding,boundariesElement);var rects={top:{width:boundaries.width,height:refRect.top-boundaries.top},right:{width:boundaries.right-refRect.right,height:boundaries.height},bottom:{width:boundaries.width,height:boundaries.bottom-refRect.bottom},left:{width:refRect.left-boundaries.left,height:boundaries.height}};var sortedAreas=Object.keys(rects).map(function(key){return _extends$1({key:key},rects[key],{area:getArea(rects[key])});}).sort(function(a,b){return b.area-a.area;});var filteredAreas=sortedAreas.filter(function(_ref2){var width=_ref2.width,height=_ref2.height;return width>=popper.clientWidth&&height>=popper.clientHeight;});var computedPlacement=filteredAreas.length>0?filteredAreas[0].key:sortedAreas[0].key;var variation=placement.split('-')[1];return computedPlacement+(variation?'-'+variation:'');}
function getReferenceOffsets(state,popper,reference){var fixedPosition=arguments.length>3&&arguments[3]!==undefined?arguments[3]:null;var commonOffsetParent=fixedPosition?getFixedPositionOffsetParent(popper):findCommonOffsetParent(popper,reference);return getOffsetRectRelativeToArbitraryNode(reference,commonOffsetParent,fixedPosition);}
function getOuterSizes(element){var styles=getComputedStyle(element);var x=parseFloat(styles.marginTop)+parseFloat(styles.marginBottom);var y=parseFloat(styles.marginLeft)+parseFloat(styles.marginRight);var result={width:element.offsetWidth+y,height:element.offsetHeight+x};return result;}
function getOppositePlacement(placement){var hash={left:'right',right:'left',bottom:'top',top:'bottom'};return placement.replace(/left|right|bottom|top/g,function(matched){return hash[matched];});}
function getPopperOffsets(popper,referenceOffsets,placement){placement=placement.split('-')[0];var popperRect=getOuterSizes(popper);var popperOffsets={width:popperRect.width,height:popperRect.height};var isHoriz=['right','left'].indexOf(placement)!==-1;var mainSide=isHoriz?'top':'left';var secondarySide=isHoriz?'left':'top';var measurement=isHoriz?'height':'width';var secondaryMeasurement=!isHoriz?'height':'width';popperOffsets[mainSide]=referenceOffsets[mainSide]+referenceOffsets[measurement]/ 2-popperRect[measurement]/ 2;if(placement===secondarySide){popperOffsets[secondarySide]=referenceOffsets[secondarySide]-popperRect[secondaryMeasurement];}else{popperOffsets[secondarySide]=referenceOffsets[getOppositePlacement(secondarySide)];}
return popperOffsets;}
function find(arr,check){if(Array.prototype.find){return arr.find(check);}
return arr.filter(check)[0];}
function findIndex(arr,prop,value){if(Array.prototype.findIndex){return arr.findIndex(function(cur){return cur[prop]===value;});}
var match=find(arr,function(obj){return obj[prop]===value;});return arr.indexOf(match);}
function runModifiers(modifiers,data,ends){var modifiersToRun=ends===undefined?modifiers:modifiers.slice(0,findIndex(modifiers,'name',ends));modifiersToRun.forEach(function(modifier){if(modifier['function']){console.warn('`modifier.function` is deprecated, use `modifier.fn`!');}
var fn=modifier['function']||modifier.fn;if(modifier.enabled&&isFunction(fn)){data.offsets.popper=getClientRect(data.offsets.popper);data.offsets.reference=getClientRect(data.offsets.reference);data=fn(data,modifier);}});return data;}
function update(){if(this.state.isDestroyed){return;}
var data={instance:this,styles:{},arrowStyles:{},attributes:{},flipped:false,offsets:{}};data.offsets.reference=getReferenceOffsets(this.state,this.popper,this.reference,this.options.positionFixed);data.placement=computeAutoPlacement(this.options.placement,data.offsets.reference,this.popper,this.reference,this.options.modifiers.flip.boundariesElement,this.options.modifiers.flip.padding);data.originalPlacement=data.placement;data.positionFixed=this.options.positionFixed;data.offsets.popper=getPopperOffsets(this.popper,data.offsets.reference,data.placement);data.offsets.popper.position=this.options.positionFixed?'fixed':'absolute';data=runModifiers(this.modifiers,data);if(!this.state.isCreated){this.state.isCreated=true;this.options.onCreate(data);}else{this.options.onUpdate(data);}}
function isModifierEnabled(modifiers,modifierName){return modifiers.some(function(_ref){var name=_ref.name,enabled=_ref.enabled;return enabled&&name===modifierName;});}
function getSupportedPropertyName(property){var prefixes=[false,'ms','Webkit','Moz','O'];var upperProp=property.charAt(0).toUpperCase()+property.slice(1);for(var i=0;i<prefixes.length;i++){var prefix=prefixes[i];var toCheck=prefix?''+prefix+upperProp:property;if(typeof document.body.style[toCheck]!=='undefined'){return toCheck;}}
return null;}
function destroy(){this.state.isDestroyed=true;if(isModifierEnabled(this.modifiers,'applyStyle')){this.popper.removeAttribute('x-placement');this.popper.style.position='';this.popper.style.top='';this.popper.style.left='';this.popper.style.right='';this.popper.style.bottom='';this.popper.style.willChange='';this.popper.style[getSupportedPropertyName('transform')]='';}
this.disableEventListeners();if(this.options.removeOnDestroy){this.popper.parentNode.removeChild(this.popper);}
return this;}
function getWindow(element){var ownerDocument=element.ownerDocument;return ownerDocument?ownerDocument.defaultView:window;}
function attachToScrollParents(scrollParent,event,callback,scrollParents){var isBody=scrollParent.nodeName==='BODY';var target=isBody?scrollParent.ownerDocument.defaultView:scrollParent;target.addEventListener(event,callback,{passive:true});if(!isBody){attachToScrollParents(getScrollParent(target.parentNode),event,callback,scrollParents);}
scrollParents.push(target);}
function setupEventListeners(reference,options,state,updateBound){state.updateBound=updateBound;getWindow(reference).addEventListener('resize',state.updateBound,{passive:true});var scrollElement=getScrollParent(reference);attachToScrollParents(scrollElement,'scroll',state.updateBound,state.scrollParents);state.scrollElement=scrollElement;state.eventsEnabled=true;return state;}
function enableEventListeners(){if(!this.state.eventsEnabled){this.state=setupEventListeners(this.reference,this.options,this.state,this.scheduleUpdate);}}
function removeEventListeners(reference,state){getWindow(reference).removeEventListener('resize',state.updateBound);state.scrollParents.forEach(function(target){target.removeEventListener('scroll',state.updateBound);});state.updateBound=null;state.scrollParents=[];state.scrollElement=null;state.eventsEnabled=false;return state;}
function disableEventListeners(){if(this.state.eventsEnabled){cancelAnimationFrame(this.scheduleUpdate);this.state=removeEventListeners(this.reference,this.state);}}
function isNumeric(n){return n!==''&&!isNaN(parseFloat(n))&&isFinite(n);}
function setStyles(element,styles){Object.keys(styles).forEach(function(prop){var unit='';if(['width','height','top','right','bottom','left'].indexOf(prop)!==-1&&isNumeric(styles[prop])){unit='px';}
element.style[prop]=styles[prop]+unit;});}
function setAttributes(element,attributes){Object.keys(attributes).forEach(function(prop){var value=attributes[prop];if(value!==false){element.setAttribute(prop,attributes[prop]);}else{element.removeAttribute(prop);}});}
function applyStyle(data){setStyles(data.instance.popper,data.styles);setAttributes(data.instance.popper,data.attributes);if(data.arrowElement&&Object.keys(data.arrowStyles).length){setStyles(data.arrowElement,data.arrowStyles);}
return data;}
function applyStyleOnLoad(reference,popper,options,modifierOptions,state){var referenceOffsets=getReferenceOffsets(state,popper,reference,options.positionFixed);var placement=computeAutoPlacement(options.placement,referenceOffsets,popper,reference,options.modifiers.flip.boundariesElement,options.modifiers.flip.padding);popper.setAttribute('x-placement',placement);setStyles(popper,{position:options.positionFixed?'fixed':'absolute'});return options;}
function computeStyle(data,options){var x=options.x,y=options.y;var popper=data.offsets.popper;var legacyGpuAccelerationOption=find(data.instance.modifiers,function(modifier){return modifier.name==='applyStyle';}).gpuAcceleration;if(legacyGpuAccelerationOption!==undefined){console.warn('WARNING: `gpuAcceleration` option moved to `computeStyle` modifier and will not be supported in future versions of Popper.js!');}
var gpuAcceleration=legacyGpuAccelerationOption!==undefined?legacyGpuAccelerationOption:options.gpuAcceleration;var offsetParent=getOffsetParent(data.instance.popper);var offsetParentRect=getBoundingClientRect(offsetParent);var styles={position:popper.position};var offsets={left:Math.floor(popper.left),top:Math.round(popper.top),bottom:Math.round(popper.bottom),right:Math.floor(popper.right)};var sideA=x==='bottom'?'top':'bottom';var sideB=y==='right'?'left':'right';var prefixedProperty=getSupportedPropertyName('transform');var left=void 0,top=void 0;if(sideA==='bottom'){top=-offsetParentRect.height+offsets.bottom;}else{top=offsets.top;}
if(sideB==='right'){left=-offsetParentRect.width+offsets.right;}else{left=offsets.left;}
if(gpuAcceleration&&prefixedProperty){styles[prefixedProperty]='translate3d('+left+'px, '+top+'px, 0)';styles[sideA]=0;styles[sideB]=0;styles.willChange='transform';}else{var invertTop=sideA==='bottom'?-1:1;var invertLeft=sideB==='right'?-1:1;styles[sideA]=top*invertTop;styles[sideB]=left*invertLeft;styles.willChange=sideA+', '+sideB;}
var attributes={'x-placement':data.placement};data.attributes=_extends$1({},attributes,data.attributes);data.styles=_extends$1({},styles,data.styles);data.arrowStyles=_extends$1({},data.offsets.arrow,data.arrowStyles);return data;}
function isModifierRequired(modifiers,requestingName,requestedName){var requesting=find(modifiers,function(_ref){var name=_ref.name;return name===requestingName;});var isRequired=!!requesting&&modifiers.some(function(modifier){return modifier.name===requestedName&&modifier.enabled&&modifier.order<requesting.order;});if(!isRequired){var _requesting='`'+requestingName+'`';var requested='`'+requestedName+'`';console.warn(requested+' modifier is required by '+_requesting+' modifier in order to work, be sure to include it before '+_requesting+'!');}
return isRequired;}
function arrow(data,options){var _data$offsets$arrow;if(!isModifierRequired(data.instance.modifiers,'arrow','keepTogether')){return data;}
var arrowElement=options.element;if(typeof arrowElement==='string'){arrowElement=data.instance.popper.querySelector(arrowElement);if(!arrowElement){return data;}}else{if(!data.instance.popper.contains(arrowElement)){console.warn('WARNING: `arrow.element` must be child of its popper element!');return data;}}
var placement=data.placement.split('-')[0];var _data$offsets=data.offsets,popper=_data$offsets.popper,reference=_data$offsets.reference;var isVertical=['left','right'].indexOf(placement)!==-1;var len=isVertical?'height':'width';var sideCapitalized=isVertical?'Top':'Left';var side=sideCapitalized.toLowerCase();var altSide=isVertical?'left':'top';var opSide=isVertical?'bottom':'right';var arrowElementSize=getOuterSizes(arrowElement)[len];if(reference[opSide]-arrowElementSize<popper[side]){data.offsets.popper[side]-=popper[side]-(reference[opSide]-arrowElementSize);}
if(reference[side]+arrowElementSize>popper[opSide]){data.offsets.popper[side]+=reference[side]+arrowElementSize-popper[opSide];}
data.offsets.popper=getClientRect(data.offsets.popper);var center=reference[side]+reference[len]/ 2-arrowElementSize / 2;var css=getStyleComputedProperty(data.instance.popper);var popperMarginSide=parseFloat(css['margin'+sideCapitalized],10);var popperBorderSide=parseFloat(css['border'+sideCapitalized+'Width'],10);var sideValue=center-data.offsets.popper[side]-popperMarginSide-popperBorderSide;sideValue=Math.max(Math.min(popper[len]-arrowElementSize,sideValue),0);data.arrowElement=arrowElement;data.offsets.arrow=(_data$offsets$arrow={},defineProperty$1(_data$offsets$arrow,side,Math.round(sideValue)),defineProperty$1(_data$offsets$arrow,altSide,''),_data$offsets$arrow);return data;}
function getOppositeVariation(variation){if(variation==='end'){return'start';}else if(variation==='start'){return'end';}
return variation;}
var placements=['auto-start','auto','auto-end','top-start','top','top-end','right-start','right','right-end','bottom-end','bottom','bottom-start','left-end','left','left-start'];var validPlacements=placements.slice(3);function clockwise(placement){var counter=arguments.length>1&&arguments[1]!==undefined?arguments[1]:false;var index=validPlacements.indexOf(placement);var arr=validPlacements.slice(index+1).concat(validPlacements.slice(0,index));return counter?arr.reverse():arr;}
var BEHAVIORS={FLIP:'flip',CLOCKWISE:'clockwise',COUNTERCLOCKWISE:'counterclockwise'};function flip(data,options){if(isModifierEnabled(data.instance.modifiers,'inner')){return data;}
if(data.flipped&&data.placement===data.originalPlacement){return data;}
var boundaries=getBoundaries(data.instance.popper,data.instance.reference,options.padding,options.boundariesElement,data.positionFixed);var placement=data.placement.split('-')[0];var placementOpposite=getOppositePlacement(placement);var variation=data.placement.split('-')[1]||'';var flipOrder=[];switch(options.behavior){case BEHAVIORS.FLIP:flipOrder=[placement,placementOpposite];break;case BEHAVIORS.CLOCKWISE:flipOrder=clockwise(placement);break;case BEHAVIORS.COUNTERCLOCKWISE:flipOrder=clockwise(placement,true);break;default:flipOrder=options.behavior;}
flipOrder.forEach(function(step,index){if(placement!==step||flipOrder.length===index+1){return data;}
placement=data.placement.split('-')[0];placementOpposite=getOppositePlacement(placement);var popperOffsets=data.offsets.popper;var refOffsets=data.offsets.reference;var floor=Math.floor;var overlapsRef=placement==='left'&&floor(popperOffsets.right)>floor(refOffsets.left)||placement==='right'&&floor(popperOffsets.left)<floor(refOffsets.right)||placement==='top'&&floor(popperOffsets.bottom)>floor(refOffsets.top)||placement==='bottom'&&floor(popperOffsets.top)<floor(refOffsets.bottom);var overflowsLeft=floor(popperOffsets.left)<floor(boundaries.left);var overflowsRight=floor(popperOffsets.right)>floor(boundaries.right);var overflowsTop=floor(popperOffsets.top)<floor(boundaries.top);var overflowsBottom=floor(popperOffsets.bottom)>floor(boundaries.bottom);var overflowsBoundaries=placement==='left'&&overflowsLeft||placement==='right'&&overflowsRight||placement==='top'&&overflowsTop||placement==='bottom'&&overflowsBottom;var isVertical=['top','bottom'].indexOf(placement)!==-1;var flippedVariation=!!options.flipVariations&&(isVertical&&variation==='start'&&overflowsLeft||isVertical&&variation==='end'&&overflowsRight||!isVertical&&variation==='start'&&overflowsTop||!isVertical&&variation==='end'&&overflowsBottom);if(overlapsRef||overflowsBoundaries||flippedVariation){data.flipped=true;if(overlapsRef||overflowsBoundaries){placement=flipOrder[index+1];}
if(flippedVariation){variation=getOppositeVariation(variation);}
data.placement=placement+(variation?'-'+variation:'');data.offsets.popper=_extends$1({},data.offsets.popper,getPopperOffsets(data.instance.popper,data.offsets.reference,data.placement));data=runModifiers(data.instance.modifiers,data,'flip');}});return data;}
function keepTogether(data){var _data$offsets=data.offsets,popper=_data$offsets.popper,reference=_data$offsets.reference;var placement=data.placement.split('-')[0];var floor=Math.floor;var isVertical=['top','bottom'].indexOf(placement)!==-1;var side=isVertical?'right':'bottom';var opSide=isVertical?'left':'top';var measurement=isVertical?'width':'height';if(popper[side]<floor(reference[opSide])){data.offsets.popper[opSide]=floor(reference[opSide])-popper[measurement];}
if(popper[opSide]>floor(reference[side])){data.offsets.popper[opSide]=floor(reference[side]);}
return data;}
function toValue(str,measurement,popperOffsets,referenceOffsets){var split=str.match(/((?:\-|\+)?\d*\.?\d*)(.*)/);var value=+split[1];var unit=split[2];if(!value){return str;}
if(unit.indexOf('%')===0){var element=void 0;switch(unit){case'%p':element=popperOffsets;break;case'%':case'%r':default:element=referenceOffsets;}
var rect=getClientRect(element);return rect[measurement]/ 100*value;}else if(unit==='vh'||unit==='vw'){var size=void 0;if(unit==='vh'){size=Math.max(document.documentElement.clientHeight,window.innerHeight||0);}else{size=Math.max(document.documentElement.clientWidth,window.innerWidth||0);}
return size / 100*value;}else{return value;}}
function parseOffset(offset,popperOffsets,referenceOffsets,basePlacement){var offsets=[0,0];var useHeight=['right','left'].indexOf(basePlacement)!==-1;var fragments=offset.split(/(\+|\-)/).map(function(frag){return frag.trim();});var divider=fragments.indexOf(find(fragments,function(frag){return frag.search(/,|\s/)!==-1;}));if(fragments[divider]&&fragments[divider].indexOf(',')===-1){console.warn('Offsets separated by white space(s) are deprecated, use a comma (,) instead.');}
var splitRegex=/\s*,\s*|\s+/;var ops=divider!==-1?[fragments.slice(0,divider).concat([fragments[divider].split(splitRegex)[0]]),[fragments[divider].split(splitRegex)[1]].concat(fragments.slice(divider+1))]:[fragments];ops=ops.map(function(op,index){var measurement=(index===1?!useHeight:useHeight)?'height':'width';var mergeWithPrevious=false;return op.reduce(function(a,b){if(a[a.length-1]===''&&['+','-'].indexOf(b)!==-1){a[a.length-1]=b;mergeWithPrevious=true;return a;}else if(mergeWithPrevious){a[a.length-1]+=b;mergeWithPrevious=false;return a;}else{return a.concat(b);}},[]).map(function(str){return toValue(str,measurement,popperOffsets,referenceOffsets);});});ops.forEach(function(op,index){op.forEach(function(frag,index2){if(isNumeric(frag)){offsets[index]+=frag*(op[index2-1]==='-'?-1:1);}});});return offsets;}
function offset(data,_ref){var offset=_ref.offset;var placement=data.placement,_data$offsets=data.offsets,popper=_data$offsets.popper,reference=_data$offsets.reference;var basePlacement=placement.split('-')[0];var offsets=void 0;if(isNumeric(+offset)){offsets=[+offset,0];}else{offsets=parseOffset(offset,popper,reference,basePlacement);}
if(basePlacement==='left'){popper.top+=offsets[0];popper.left-=offsets[1];}else if(basePlacement==='right'){popper.top+=offsets[0];popper.left+=offsets[1];}else if(basePlacement==='top'){popper.left+=offsets[0];popper.top-=offsets[1];}else if(basePlacement==='bottom'){popper.left+=offsets[0];popper.top+=offsets[1];}
data.popper=popper;return data;}
function preventOverflow(data,options){var boundariesElement=options.boundariesElement||getOffsetParent(data.instance.popper);if(data.instance.reference===boundariesElement){boundariesElement=getOffsetParent(boundariesElement);}
var transformProp=getSupportedPropertyName('transform');var popperStyles=data.instance.popper.style;var top=popperStyles.top,left=popperStyles.left,transform=popperStyles[transformProp];popperStyles.top='';popperStyles.left='';popperStyles[transformProp]='';var boundaries=getBoundaries(data.instance.popper,data.instance.reference,options.padding,boundariesElement,data.positionFixed);popperStyles.top=top;popperStyles.left=left;popperStyles[transformProp]=transform;options.boundaries=boundaries;var order=options.priority;var popper=data.offsets.popper;var check={primary:function primary(placement){var value=popper[placement];if(popper[placement]<boundaries[placement]&&!options.escapeWithReference){value=Math.max(popper[placement],boundaries[placement]);}
return defineProperty$1({},placement,value);},secondary:function secondary(placement){var mainSide=placement==='right'?'left':'top';var value=popper[mainSide];if(popper[placement]>boundaries[placement]&&!options.escapeWithReference){value=Math.min(popper[mainSide],boundaries[placement]-(placement==='right'?popper.width:popper.height));}
return defineProperty$1({},mainSide,value);}};order.forEach(function(placement){var side=['left','top'].indexOf(placement)!==-1?'primary':'secondary';popper=_extends$1({},popper,check[side](placement));});data.offsets.popper=popper;return data;}
function shift(data){var placement=data.placement;var basePlacement=placement.split('-')[0];var shiftvariation=placement.split('-')[1];if(shiftvariation){var _data$offsets=data.offsets,reference=_data$offsets.reference,popper=_data$offsets.popper;var isVertical=['bottom','top'].indexOf(basePlacement)!==-1;var side=isVertical?'left':'top';var measurement=isVertical?'width':'height';var shiftOffsets={start:defineProperty$1({},side,reference[side]),end:defineProperty$1({},side,reference[side]+reference[measurement]-popper[measurement])};data.offsets.popper=_extends$1({},popper,shiftOffsets[shiftvariation]);}
return data;}
function hide(data){if(!isModifierRequired(data.instance.modifiers,'hide','preventOverflow')){return data;}
var refRect=data.offsets.reference;var bound=find(data.instance.modifiers,function(modifier){return modifier.name==='preventOverflow';}).boundaries;if(refRect.bottom<bound.top||refRect.left>bound.right||refRect.top>bound.bottom||refRect.right<bound.left){if(data.hide===true){return data;}
data.hide=true;data.attributes['x-out-of-boundaries']='';}else{if(data.hide===false){return data;}
data.hide=false;data.attributes['x-out-of-boundaries']=false;}
return data;}
function inner(data){var placement=data.placement;var basePlacement=placement.split('-')[0];var _data$offsets=data.offsets,popper=_data$offsets.popper,reference=_data$offsets.reference;var isHoriz=['left','right'].indexOf(basePlacement)!==-1;var subtractLength=['top','left'].indexOf(basePlacement)===-1;popper[isHoriz?'left':'top']=reference[basePlacement]-(subtractLength?popper[isHoriz?'width':'height']:0);data.placement=getOppositePlacement(placement);data.offsets.popper=getClientRect(popper);return data;}
var modifiers={shift:{order:100,enabled:true,fn:shift},offset:{order:200,enabled:true,fn:offset,offset:0},preventOverflow:{order:300,enabled:true,fn:preventOverflow,priority:['left','right','top','bottom'],padding:5,boundariesElement:'scrollParent'},keepTogether:{order:400,enabled:true,fn:keepTogether},arrow:{order:500,enabled:true,fn:arrow,element:'[x-arrow]'},flip:{order:600,enabled:true,fn:flip,behavior:'flip',padding:5,boundariesElement:'viewport'},inner:{order:700,enabled:false,fn:inner},hide:{order:800,enabled:true,fn:hide},computeStyle:{order:850,enabled:true,fn:computeStyle,gpuAcceleration:true,x:'bottom',y:'right'},applyStyle:{order:900,enabled:true,fn:applyStyle,onLoad:applyStyleOnLoad,gpuAcceleration:undefined}};var Defaults={placement:'bottom',positionFixed:false,eventsEnabled:true,removeOnDestroy:false,onCreate:function onCreate(){},onUpdate:function onUpdate(){},modifiers:modifiers};var Popper=function(){function Popper(reference,popper){var _this=this;var options=arguments.length>2&&arguments[2]!==undefined?arguments[2]:{};classCallCheck$1(this,Popper);this.scheduleUpdate=function(){return requestAnimationFrame(_this.update);};this.update=debounce(this.update.bind(this));this.options=_extends$1({},Popper.Defaults,options);this.state={isDestroyed:false,isCreated:false,scrollParents:[]};this.reference=reference&&reference.jquery?reference[0]:reference;this.popper=popper&&popper.jquery?popper[0]:popper;this.options.modifiers={};Object.keys(_extends$1({},Popper.Defaults.modifiers,options.modifiers)).forEach(function(name){_this.options.modifiers[name]=_extends$1({},Popper.Defaults.modifiers[name]||{},options.modifiers?options.modifiers[name]:{});});this.modifiers=Object.keys(this.options.modifiers).map(function(name){return _extends$1({name:name},_this.options.modifiers[name]);}).sort(function(a,b){return a.order-b.order;});this.modifiers.forEach(function(modifierOptions){if(modifierOptions.enabled&&isFunction(modifierOptions.onLoad)){modifierOptions.onLoad(_this.reference,_this.popper,_this.options,modifierOptions,_this.state);}});this.update();var eventsEnabled=this.options.eventsEnabled;if(eventsEnabled){this.enableEventListeners();}
this.state.eventsEnabled=eventsEnabled;}
createClass$1(Popper,[{key:'update',value:function update$$1(){return update.call(this);}},{key:'destroy',value:function destroy$$1(){return destroy.call(this);}},{key:'enableEventListeners',value:function enableEventListeners$$1(){return enableEventListeners.call(this);}},{key:'disableEventListeners',value:function disableEventListeners$$1(){return disableEventListeners.call(this);}}]);return Popper;}();Popper.Utils=(typeof window!=='undefined'?window:global).PopperUtils;Popper.placements=placements;Popper.Defaults=Defaults;function reflow(popper){void popper.offsetHeight;}
function updatePopperPosition(popperInstance,callback,updateAlreadyCalled){var popper=popperInstance.popper,options=popperInstance.options;var onCreate=options.onCreate;var onUpdate=options.onUpdate;options.onCreate=options.onUpdate=function(){reflow(popper),callback&&callback(),onUpdate();options.onCreate=onCreate;options.onUpdate=onUpdate;};if(!updateAlreadyCalled){popperInstance.scheduleUpdate();}}
function getPopperPlacement(popper){return popper.getAttribute('x-placement').replace(/-.+/,'');}
function cursorIsOutsideInteractiveBorder(event,popper,options){if(!popper.getAttribute('x-placement'))return true;var x=event.clientX,y=event.clientY;var interactiveBorder=options.interactiveBorder,distance=options.distance;var rect=popper.getBoundingClientRect();var placement=getPopperPlacement(popper);var borderWithDistance=interactiveBorder+distance;var exceeds={top:rect.top-y>interactiveBorder,bottom:y-rect.bottom>interactiveBorder,left:rect.left-x>interactiveBorder,right:x-rect.right>interactiveBorder};switch(placement){case'top':exceeds.top=rect.top-y>borderWithDistance;break;case'bottom':exceeds.bottom=y-rect.bottom>borderWithDistance;break;case'left':exceeds.left=rect.left-x>borderWithDistance;break;case'right':exceeds.right=x-rect.right>borderWithDistance;break;}
return exceeds.top||exceeds.bottom||exceeds.left||exceeds.right;}
function transformNumbersBasedOnPlacementAxis(type,numbers,isVertical,isReverse){if(!numbers.length)return'';var transforms={scale:function(){if(numbers.length===1){return''+numbers[0];}else{return isVertical?numbers[0]+', '+numbers[1]:numbers[1]+', '+numbers[0];}}(),translate:function(){if(numbers.length===1){return isReverse?-numbers[0]+'px':numbers[0]+'px';}else{if(isVertical){return isReverse?numbers[0]+'px, '+ -numbers[1]+'px':numbers[0]+'px, '+numbers[1]+'px';}else{return isReverse?-numbers[1]+'px, '+numbers[0]+'px':numbers[1]+'px, '+numbers[0]+'px';}}}()};return transforms[type];}
function transformAxis(axis,isVertical){if(!axis)return'';var map={X:'Y',Y:'X'};return isVertical?axis:map[axis];}
function computeArrowTransform(popper,arrow,arrowTransform){var placement=getPopperPlacement(popper);var isVertical=placement==='top'||placement==='bottom';var isReverse=placement==='right'||placement==='bottom';var getAxis=function getAxis(re){var match=arrowTransform.match(re);return match?match[1]:'';};var getNumbers=function getNumbers(re){var match=arrowTransform.match(re);return match?match[1].split(',').map(parseFloat):[];};var re={translate:/translateX?Y?\(([^)]+)\)/,scale:/scaleX?Y?\(([^)]+)\)/};var matches={translate:{axis:getAxis(/translate([XY])/),numbers:getNumbers(re.translate)},scale:{axis:getAxis(/scale([XY])/),numbers:getNumbers(re.scale)}};var computedTransform=arrowTransform.replace(re.translate,'translate'+transformAxis(matches.translate.axis,isVertical)+'('+transformNumbersBasedOnPlacementAxis('translate',matches.translate.numbers,isVertical,isReverse)+')').replace(re.scale,'scale'+transformAxis(matches.scale.axis,isVertical)+'('+transformNumbersBasedOnPlacementAxis('scale',matches.scale.numbers,isVertical,isReverse)+')');arrow.style[prefix('transform')]=computedTransform;}
function getOffsetDistanceInPx(distance){return-(distance-defaults.distance)+'px';}
function defer(fn){requestAnimationFrame(function(){setTimeout(fn,1);});}
var matches={};if(isBrowser){var e=Element.prototype;matches=e.matches||e.matchesSelector||e.webkitMatchesSelector||e.mozMatchesSelector||e.msMatchesSelector||function(s){var matches=(this.document||this.ownerDocument).querySelectorAll(s);var i=matches.length;while(--i>=0&&matches.item(i)!==this){}
return i>-1;};}
var matches$1=matches;function closest(element,parentSelector){var fn=Element.prototype.closest||function(selector){var el=this;while(el){if(matches$1.call(el,selector)){return el;}
el=el.parentElement;}};return fn.call(element,parentSelector);}
function getValue(value,index){return Array.isArray(value)?value[index]:value;}
function setVisibilityState(els,type){els.forEach(function(el){if(!el)return;el.setAttribute('data-state',type);});}
function applyTransitionDuration(els,value){els.filter(Boolean).forEach(function(el){el.style[prefix('transitionDuration')]=value+'ms';});}
function focus(el){var x=window.scrollX||window.pageXOffset;var y=window.scrollY||window.pageYOffset;el.focus();scroll(x,y);}
var key={};var store=function store(data){return function(k){return k===key&&data;};};var Tippy=function(){function Tippy(config){classCallCheck(this,Tippy);for(var _key in config){this[_key]=config[_key];}
this.state={destroyed:false,visible:false,enabled:true};this._=store({mutationObservers:[]});}
createClass(Tippy,[{key:'enable',value:function enable(){this.state.enabled=true;}},{key:'disable',value:function disable(){this.state.enabled=false;}},{key:'show',value:function show(duration){var _this=this;if(this.state.destroyed||!this.state.enabled)return;var popper=this.popper,reference=this.reference,options=this.options;var _getInnerElements=getInnerElements(popper),tooltip=_getInnerElements.tooltip,backdrop=_getInnerElements.backdrop,content=_getInnerElements.content;if(options.dynamicTitle&&!reference.getAttribute('data-original-title')){return;}
if(reference.hasAttribute('disabled'))return;if(!reference.refObj&&!document.documentElement.contains(reference)){this.destroy();return;}
options.onShow.call(popper,this);duration=getValue(duration!==undefined?duration:options.duration,0);applyTransitionDuration([popper,tooltip,backdrop],0);popper.style.visibility='visible';this.state.visible=true;_mount.call(this,function(){if(!_this.state.visible)return;if(!_hasFollowCursorBehavior.call(_this)){_this.popperInstance.scheduleUpdate();}
if(_hasFollowCursorBehavior.call(_this)){_this.popperInstance.disableEventListeners();var delay=getValue(options.delay,0);var lastTriggerEvent=_this._(key).lastTriggerEvent;if(lastTriggerEvent){_this._(key).followCursorListener(delay&&_this._(key).lastMouseMoveEvent?_this._(key).lastMouseMoveEvent:lastTriggerEvent);}}
applyTransitionDuration([tooltip,backdrop,backdrop?content:null],duration);if(backdrop){getComputedStyle(backdrop)[prefix('transform')];}
if(options.interactive){reference.classList.add('tippy-active');}
if(options.sticky){_makeSticky.call(_this);}
setVisibilityState([tooltip,backdrop],'visible');_onTransitionEnd.call(_this,duration,function(){if(!options.updateDuration){tooltip.classList.add('tippy-notransition');}
if(options.interactive){focus(popper);}
reference.setAttribute('aria-describedby','tippy-'+_this.id);options.onShown.call(popper,_this);});});}},{key:'hide',value:function hide(duration){var _this2=this;if(this.state.destroyed||!this.state.enabled)return;var popper=this.popper,reference=this.reference,options=this.options;var _getInnerElements2=getInnerElements(popper),tooltip=_getInnerElements2.tooltip,backdrop=_getInnerElements2.backdrop,content=_getInnerElements2.content;options.onHide.call(popper,this);duration=getValue(duration!==undefined?duration:options.duration,1);if(!options.updateDuration){tooltip.classList.remove('tippy-notransition');}
if(options.interactive){reference.classList.remove('tippy-active');}
popper.style.visibility='hidden';this.state.visible=false;applyTransitionDuration([tooltip,backdrop,backdrop?content:null],duration);setVisibilityState([tooltip,backdrop],'hidden');if(options.interactive&&options.trigger.indexOf('click')>-1){focus(reference);}
defer(function(){_onTransitionEnd.call(_this2,duration,function(){if(_this2.state.visible||!options.appendTo.contains(popper))return;if(!_this2._(key).isPreparingToShow){document.removeEventListener('mousemove',_this2._(key).followCursorListener);_this2._(key).lastMouseMoveEvent=null;}
if(_this2.popperInstance){_this2.popperInstance.disableEventListeners();}
reference.removeAttribute('aria-describedby');options.appendTo.removeChild(popper);options.onHidden.call(popper,_this2);});});}},{key:'destroy',value:function destroy(){var _this3=this;var destroyTargetInstances=arguments.length>0&&arguments[0]!==undefined?arguments[0]:true;if(this.state.destroyed)return;if(this.state.visible){this.hide(0);}
this.listeners.forEach(function(listener){_this3.reference.removeEventListener(listener.event,listener.handler);});if(this.title){this.reference.setAttribute('title',this.title);}
delete this.reference._tippy;var attributes=['data-original-title','data-tippy','data-tippy-delegate'];attributes.forEach(function(attr){_this3.reference.removeAttribute(attr);});if(this.options.target&&destroyTargetInstances){toArray(this.reference.querySelectorAll(this.options.target)).forEach(function(child){return child._tippy&&child._tippy.destroy();});}
if(this.popperInstance){this.popperInstance.destroy();}
this._(key).mutationObservers.forEach(function(observer){observer.disconnect();});this.state.destroyed=true;}}]);return Tippy;}();function _hasFollowCursorBehavior(){var lastTriggerEvent=this._(key).lastTriggerEvent;return this.options.followCursor&&!browser.usingTouch&&lastTriggerEvent&&lastTriggerEvent.type!=='focus';}
function _createDelegateChildTippy(event){var targetEl=closest(event.target,this.options.target);if(targetEl&&!targetEl._tippy){var title=targetEl.getAttribute('title')||this.title;if(title){targetEl.setAttribute('title',title);tippy(targetEl,_extends({},this.options,{target:null}));_enter.call(targetEl._tippy,event);}}}
function _enter(event){var _this4=this;var options=this.options;_clearDelayTimeouts.call(this);if(this.state.visible)return;if(options.target){_createDelegateChildTippy.call(this,event);return;}
this._(key).isPreparingToShow=true;if(options.wait){options.wait.call(this.popper,this.show.bind(this),event);return;}
if(_hasFollowCursorBehavior.call(this)){if(!this._(key).followCursorListener){_setFollowCursorListener.call(this);}
var _getInnerElements3=getInnerElements(this.popper),arrow=_getInnerElements3.arrow;if(arrow)arrow.style.margin='0';document.addEventListener('mousemove',this._(key).followCursorListener);}
var delay=getValue(options.delay,0);if(delay){this._(key).showTimeout=setTimeout(function(){_this4.show();},delay);}else{this.show();}}
function _leave(){var _this5=this;_clearDelayTimeouts.call(this);if(!this.state.visible)return;this._(key).isPreparingToShow=false;var delay=getValue(this.options.delay,1);if(delay){this._(key).hideTimeout=setTimeout(function(){if(_this5.state.visible){_this5.hide();}},delay);}else{this.hide();}}
function _getEventListeners(){var _this6=this;var onTrigger=function onTrigger(event){if(!_this6.state.enabled)return;var shouldStopEvent=browser.supportsTouch&&browser.usingTouch&&['mouseenter','mouseover','focus'].indexOf(event.type)>-1;if(shouldStopEvent&&_this6.options.touchHold)return;_this6._(key).lastTriggerEvent=event;if(event.type==='click'&&_this6.options.hideOnClick!=='persistent'&&_this6.state.visible){_leave.call(_this6);}else{_enter.call(_this6,event);}};var onMouseLeave=function onMouseLeave(event){if(['mouseleave','mouseout'].indexOf(event.type)>-1&&browser.supportsTouch&&browser.usingTouch&&_this6.options.touchHold)return;if(_this6.options.interactive){var hide=_leave.bind(_this6);var onMouseMove=function onMouseMove(event){var referenceCursorIsOver=closest(event.target,selectors.REFERENCE);var cursorIsOverPopper=closest(event.target,selectors.POPPER)===_this6.popper;var cursorIsOverReference=referenceCursorIsOver===_this6.reference;if(cursorIsOverPopper||cursorIsOverReference)return;if(cursorIsOutsideInteractiveBorder(event,_this6.popper,_this6.options)){document.body.removeEventListener('mouseleave',hide);document.removeEventListener('mousemove',onMouseMove);_leave.call(_this6,onMouseMove);}};document.body.addEventListener('mouseleave',hide);document.addEventListener('mousemove',onMouseMove);return;}
_leave.call(_this6);};var onBlur=function onBlur(event){if(event.target!==_this6.reference||browser.usingTouch)return;if(_this6.options.interactive){if(!event.relatedTarget)return;if(closest(event.relatedTarget,selectors.POPPER))return;}
_leave.call(_this6);};var onDelegateShow=function onDelegateShow(event){if(closest(event.target,_this6.options.target)){_enter.call(_this6,event);}};var onDelegateHide=function onDelegateHide(event){if(closest(event.target,_this6.options.target)){_leave.call(_this6);}};return{onTrigger:onTrigger,onMouseLeave:onMouseLeave,onBlur:onBlur,onDelegateShow:onDelegateShow,onDelegateHide:onDelegateHide};}
function _createPopperInstance(){var _this7=this;var popper=this.popper,reference=this.reference,options=this.options;var _getInnerElements4=getInnerElements(popper),tooltip=_getInnerElements4.tooltip;var popperOptions=options.popperOptions;var arrowSelector=options.arrowType==='round'?selectors.ROUND_ARROW:selectors.ARROW;var arrow=tooltip.querySelector(arrowSelector);var config=_extends({placement:options.placement},popperOptions||{},{modifiers:_extends({},popperOptions?popperOptions.modifiers:{},{arrow:_extends({element:arrowSelector},popperOptions&&popperOptions.modifiers?popperOptions.modifiers.arrow:{}),flip:_extends({enabled:options.flip,padding:options.distance+5,behavior:options.flipBehavior},popperOptions&&popperOptions.modifiers?popperOptions.modifiers.flip:{}),offset:_extends({offset:options.offset},popperOptions&&popperOptions.modifiers?popperOptions.modifiers.offset:{})}),onCreate:function onCreate(){tooltip.style[getPopperPlacement(popper)]=getOffsetDistanceInPx(options.distance);if(arrow&&options.arrowTransform){computeArrowTransform(popper,arrow,options.arrowTransform);}},onUpdate:function onUpdate(){var styles=tooltip.style;styles.top='';styles.bottom='';styles.left='';styles.right='';styles[getPopperPlacement(popper)]=getOffsetDistanceInPx(options.distance);if(arrow&&options.arrowTransform){computeArrowTransform(popper,arrow,options.arrowTransform);}}});_addMutationObserver.call(this,{target:popper,callback:function callback(){_this7.popperInstance.update();},options:{childList:true,subtree:true,characterData:true}});return new Popper(reference,popper,config);}
function _mount(callback){var options=this.options;if(!this.popperInstance){this.popperInstance=_createPopperInstance.call(this);if(!options.livePlacement){this.popperInstance.disableEventListeners();}}else{this.popperInstance.scheduleUpdate();if(options.livePlacement&&!_hasFollowCursorBehavior.call(this)){this.popperInstance.enableEventListeners();}}
if(!_hasFollowCursorBehavior.call(this)){var _getInnerElements5=getInnerElements(this.popper),arrow=_getInnerElements5.arrow;if(arrow)arrow.style.margin='';this.popperInstance.reference=this.reference;}
updatePopperPosition(this.popperInstance,callback,true);if(!options.appendTo.contains(this.popper)){options.appendTo.appendChild(this.popper);}}
function _clearDelayTimeouts(){var _ref=this._(key),showTimeout=_ref.showTimeout,hideTimeout=_ref.hideTimeout;clearTimeout(showTimeout);clearTimeout(hideTimeout);}
function _setFollowCursorListener(){var _this8=this;this._(key).followCursorListener=function(event){var _$lastMouseMoveEvent=_this8._(key).lastMouseMoveEvent=event,clientX=_$lastMouseMoveEvent.clientX,clientY=_$lastMouseMoveEvent.clientY;if(!_this8.popperInstance)return;_this8.popperInstance.reference={getBoundingClientRect:function getBoundingClientRect(){return{width:0,height:0,top:clientY,left:clientX,right:clientX,bottom:clientY};},clientWidth:0,clientHeight:0};_this8.popperInstance.scheduleUpdate();};}
function _makeSticky(){var _this9=this;var applyTransitionDuration$$1=function applyTransitionDuration$$1(){_this9.popper.style[prefix('transitionDuration')]=_this9.options.updateDuration+'ms';};var removeTransitionDuration=function removeTransitionDuration(){_this9.popper.style[prefix('transitionDuration')]='';};var updatePosition=function updatePosition(){if(_this9.popperInstance){_this9.popperInstance.update();}
applyTransitionDuration$$1();if(_this9.state.visible){requestAnimationFrame(updatePosition);}else{removeTransitionDuration();}};updatePosition();}
function _addMutationObserver(_ref2){var target=_ref2.target,callback=_ref2.callback,options=_ref2.options;if(!window.MutationObserver)return;var observer=new MutationObserver(callback);observer.observe(target,options);this._(key).mutationObservers.push(observer);}
function _onTransitionEnd(duration,callback){if(!duration){return callback();}
var _getInnerElements6=getInnerElements(this.popper),tooltip=_getInnerElements6.tooltip;var toggleListeners=function toggleListeners(action,listener){if(!listener)return;tooltip[action+'EventListener']('transition'in document.body.style?'transitionend':'webkitTransitionEnd',listener);};var listener=function listener(e){if(e.target===tooltip){toggleListeners('remove',listener);callback();}};toggleListeners('remove',this._(key).transitionendListener);toggleListeners('add',listener);this._(key).transitionendListener=listener;}
var idCounter=1;function createTooltips(els,config){return els.reduce(function(acc,reference){var id=idCounter;var options=evaluateOptions(reference,config.performance?config:getIndividualOptions(reference,config));var title=reference.getAttribute('title');if(!title&&!options.target&&!options.html&&!options.dynamicTitle){return acc;}
reference.setAttribute(options.target?'data-tippy-delegate':'data-tippy','');removeTitle(reference);var popper=createPopperElement(id,title,options);var tippy=new Tippy({id:id,reference:reference,popper:popper,options:options,title:title,popperInstance:null});if(options.createPopperInstanceOnInit){tippy.popperInstance=_createPopperInstance.call(tippy);tippy.popperInstance.disableEventListeners();}
var listeners=_getEventListeners.call(tippy);tippy.listeners=options.trigger.trim().split(' ').reduce(function(acc,eventType){return acc.concat(createTrigger(eventType,reference,listeners,options));},[]);if(options.dynamicTitle){_addMutationObserver.call(tippy,{target:reference,callback:function callback(){var _getInnerElements=getInnerElements(popper),content=_getInnerElements.content;var title=reference.getAttribute('title');if(title){content[options.allowTitleHTML?'innerHTML':'textContent']=tippy.title=title;removeTitle(reference);}},options:{attributes:true}});}
reference._tippy=tippy;popper._tippy=tippy;popper._reference=reference;acc.push(tippy);idCounter++;return acc;},[]);}
function hideAllPoppers(excludeTippy){var poppers=toArray(document.querySelectorAll(selectors.POPPER));poppers.forEach(function(popper){var tippy=popper._tippy;if(!tippy)return;var options=tippy.options;if((options.hideOnClick===true||options.trigger.indexOf('focus')>-1)&&(!excludeTippy||popper!==excludeTippy.popper)){tippy.hide();}});}
function bindEventListeners(){var onDocumentTouch=function onDocumentTouch(){if(browser.usingTouch)return;browser.usingTouch=true;if(browser.iOS){document.body.classList.add('tippy-touch');}
if(browser.dynamicInputDetection&&window.performance){document.addEventListener('mousemove',onDocumentMouseMove);}
browser.onUserInputChange('touch');};var onDocumentMouseMove=function(){var time=void 0;return function(){var now=performance.now();if(now-time<20){browser.usingTouch=false;document.removeEventListener('mousemove',onDocumentMouseMove);if(!browser.iOS){document.body.classList.remove('tippy-touch');}
browser.onUserInputChange('mouse');}
time=now;};}();var onDocumentClick=function onDocumentClick(event){if(!(event.target instanceof Element)){return hideAllPoppers();}
var reference=closest(event.target,selectors.REFERENCE);var popper=closest(event.target,selectors.POPPER);if(popper&&popper._tippy&&popper._tippy.options.interactive){return;}
if(reference&&reference._tippy){var options=reference._tippy.options;var isClickTrigger=options.trigger.indexOf('click')>-1;var isMultiple=options.multiple;if(!isMultiple&&browser.usingTouch||!isMultiple&&isClickTrigger){return hideAllPoppers(reference._tippy);}
if(options.hideOnClick!==true||isClickTrigger){return;}}
hideAllPoppers();};var onWindowBlur=function onWindowBlur(){var _document=document,el=_document.activeElement;if(el&&el.blur&&matches$1.call(el,selectors.REFERENCE)){el.blur();}};var onWindowResize=function onWindowResize(){toArray(document.querySelectorAll(selectors.POPPER)).forEach(function(popper){var tippyInstance=popper._tippy;if(tippyInstance&&!tippyInstance.options.livePlacement){tippyInstance.popperInstance.scheduleUpdate();}});};document.addEventListener('click',onDocumentClick);document.addEventListener('touchstart',onDocumentTouch);window.addEventListener('blur',onWindowBlur);window.addEventListener('resize',onWindowResize);if(!browser.supportsTouch&&(navigator.maxTouchPoints||navigator.msMaxTouchPoints)){document.addEventListener('pointerdown',onDocumentTouch);}}
var eventListenersBound=false;function tippy(selector,options,one){if(browser.supported&&!eventListenersBound){bindEventListeners();eventListenersBound=true;}
if(isObjectLiteral(selector)){polyfillVirtualReferenceProps(selector);}
options=_extends({},defaults,options);var references=getArrayOfElements(selector);var firstReference=references[0];return{selector:selector,options:options,tooltips:browser.supported?createTooltips(one&&firstReference?[firstReference]:references,options):[],destroyAll:function destroyAll(){this.tooltips.forEach(function(tooltip){return tooltip.destroy();});this.tooltips=[];}};}
tippy.version=version;tippy.browser=browser;tippy.defaults=defaults;tippy.one=function(selector,options){return tippy(selector,options,true).tooltips[0];};tippy.disableAnimations=function(){defaults.updateDuration=defaults.duration=0;defaults.animateFill=false;};function injectCSS(){var css=arguments.length>0&&arguments[0]!==undefined?arguments[0]:'';if(isBrowser&&browser.supported){var head=document.head||document.querySelector('head');var style=document.createElement('style');style.type='text/css';head.insertBefore(style,head.firstChild);if(style.styleSheet){style.styleSheet.cssText=css;}else{style.appendChild(document.createTextNode(css));}}}
injectCSS(styles);return tippy;})));