define(['underscore','ko','mageUtils','uiComponent','Magento_Checkout/js/model/payment/method-list','Magento_Checkout/js/model/payment/renderer-list','uiLayout','Magento_Checkout/js/model/checkout-data-resolver','mage/translate','uiRegistry'],function(_,ko,utils,Component,paymentMethods,rendererList,layout,checkoutDataResolver,$t,registry){'use strict';return Component.extend({defaults:{template:'Magento_Checkout/payment-methods/list',visible:paymentMethods().length>0,configDefaultGroup:{name:'methodGroup',component:'Magento_Checkout/js/model/payment/method-group'},paymentGroupsList:[],defaultGroupTitle:$t('Select a new payment method')},initialize:function(){this._super().initDefaulGroup().initChildren();paymentMethods.subscribe(function(changes){checkoutDataResolver.resolvePaymentMethod();_.each(changes,function(change){if(change.status==='deleted'){this.removeRenderer(change.value.method);}},this);_.each(changes,function(change){if(change.status==='added'){this.createRenderer(change.value);}},this);},this,'arrayChange');return this;},initObservable:function(){this._super().observe(['paymentGroupsList']);return this;},initDefaulGroup:function(){layout([this.configDefaultGroup]);return this;},initChildren:function(){var self=this;_.each(paymentMethods(),function(paymentMethodData){self.createRenderer(paymentMethodData);});return this;},createComponent:function(payment){var rendererTemplate,rendererComponent,templateData;templateData={parentName:this.name,name:payment.name};rendererTemplate={parent:'${ $.$data.parentName }',name:'${ $.$data.name }',displayArea:payment.displayArea,component:payment.component};rendererComponent=utils.template(rendererTemplate,templateData);utils.extend(rendererComponent,{item:payment.item,config:payment.config});return rendererComponent;},createRenderer:function(paymentMethodData){var isRendererForMethod=false,currentGroup;registry.get(this.configDefaultGroup.name,function(defaultGroup){_.each(rendererList(),function(renderer){if(renderer.hasOwnProperty('typeComparatorCallback')&&typeof renderer.typeComparatorCallback=='function'){isRendererForMethod=renderer.typeComparatorCallback(renderer.type,paymentMethodData.method);}else{isRendererForMethod=renderer.type===paymentMethodData.method;}
if(isRendererForMethod){currentGroup=renderer.group?renderer.group:defaultGroup;this.collectPaymentGroups(currentGroup);layout([this.createComponent({config:renderer.config,component:renderer.component,name:renderer.type,method:paymentMethodData.method,item:paymentMethodData,displayArea:currentGroup.displayArea})]);}}.bind(this));}.bind(this));},collectPaymentGroups:function(group){var groupsList=this.paymentGroupsList(),isGroupExists=_.some(groupsList,function(existsGroup){return existsGroup.alias===group.alias;});if(!isGroupExists){groupsList.push(group);groupsList=_.sortBy(groupsList,function(existsGroup){return existsGroup.sortOrder;});this.paymentGroupsList(groupsList);}},getGroupTitle:function(group){var title=group().title;if(group().isDefault()&&this.paymentGroupsList().length>1){title=this.defaultGroupTitle;}
return title;},isPaymentMethodsAvailable:function(){return _.some(this.paymentGroupsList(),function(group){return this.getRegion(group.displayArea)().length;},this);},removeRenderer:function(paymentMethodCode){var items;_.each(this.paymentGroupsList(),function(group){items=this.getRegion(group.displayArea);_.find(items(),function(value){if(value.item.method.indexOf(paymentMethodCode)===0){value.disposeSubscriptions();value.destroy();}});},this);}});});