<?php
/**
 * Copyright ©  All rights reserved.
 * See COPYING.txt for license details.
 */
declare(strict_types=1);

namespace Aplazo\AplazoPayment\Model\Data;

use Aplazo\AplazoPayment\Api\Data\SaleInterface;

class Sale extends \Magento\Framework\Api\AbstractExtensibleObject implements SaleInterface
{
    const STATUS_PENDING = 'pending';
    const STATUS_PROCESSING = 'processing';
    const STATUS_CANCELLED = 'cancelled';
    const STATUS_REFUNDED = 'refunded';
    const STATUS_ERROR = 'webhook_error';

    /**
     * Get sale_id
     * @return string|null
     */
    public function getSaleId()
    {
        return $this->_get(self::SALE_ID);
    }

    /**
     * Set sale_id
     * @param string $saleId
     * @return \Aplazo\AplazoPayment\Api\Data\SaleInterface
     */
    public function setSaleId($saleId)
    {
        return $this->setData(self::SALE_ID, $saleId);
    }

    /**
     * Get quote_id
     * @return string|null
     */
    public function getQuoteId()
    {
        return $this->_get(self::QUOTE_ID);
    }

    /**
     * Set quote_id
     * @param string $quoteId
     * @return \Aplazo\AplazoPayment\Api\Data\SaleInterface
     */
    public function setQuoteId($quoteId)
    {
        return $this->setData(self::QUOTE_ID, $quoteId);
    }

    /**
     * Retrieve existing extension attributes object or create a new one.
     * @return \Aplazo\AplazoPayment\Api\Data\SaleExtensionInterface|null
     */
    public function getExtensionAttributes()
    {
        return $this->_getExtensionAttributes();
    }

    /**
     * Set an extension attributes object.
     * @param \Aplazo\AplazoPayment\Api\Data\SaleExtensionInterface $extensionAttributes
     * @return $this
     */
    public function setExtensionAttributes(
        \Aplazo\AplazoPayment\Api\Data\SaleExtensionInterface $extensionAttributes
    ) {
        return $this->_setExtensionAttributes($extensionAttributes);
    }

    /**
     * Get reserved_order_id
     * @return string|null
     */
    public function getReservedOrderId()
    {
        return $this->_get(self::RESERVED_ORDER_ID);
    }

    /**
     * Set reserved_order_id
     * @param string $reservedOrderId
     * @return \Aplazo\AplazoPayment\Api\Data\SaleInterface
     */
    public function setReservedOrderId($reservedOrderId)
    {
        return $this->setData(self::RESERVED_ORDER_ID, $reservedOrderId);
    }

    /**
     * Get firstname
     * @return string|null
     */
    public function getFirstname()
    {
        return $this->_get(self::FIRSTNAME);
    }

    /**
     * Set firstname
     * @param string $firstname
     * @return \Aplazo\AplazoPayment\Api\Data\SaleInterface
     */
    public function setFirstname($firstname)
    {
        return $this->setData(self::FIRSTNAME, $firstname);
    }

    /**
     * Get lastname
     * @return string|null
     */
    public function getLastname()
    {
        return $this->_get(self::LASTNAME);
    }

    /**
     * Set lastname
     * @param string $lastname
     * @return \Aplazo\AplazoPayment\Api\Data\SaleInterface
     */
    public function setLastname($lastname)
    {
        return $this->setData(self::LASTNAME, $lastname);
    }

    /**
     * Get email
     * @return string|null
     */
    public function getEmail()
    {
        return $this->_get(self::EMAIL);
    }

    /**
     * Set email
     * @param string $email
     * @return \Aplazo\AplazoPayment\Api\Data\SaleInterface
     */
    public function setEmail($email)
    {
        return $this->setData(self::EMAIL, $email);
    }

    /**
     * Get status
     * @return string|null
     */
    public function getStatus()
    {
        return $this->_get(self::STATUS);
    }

    /**
     * Set status
     * @param string $status
     * @return \Aplazo\AplazoPayment\Api\Data\SaleInterface
     */
    public function setStatus($status)
    {
        return $this->setData(self::STATUS, $status);
    }

    /**
     * Get loanId
     * @return string|null
     */
    public function getLoanId()
    {
        return $this->_get(self::LOAN_ID);
    }

    /**
     * Set loanId
     * @param string $loanId
     * @return \Aplazo\AplazoPayment\Api\Data\SaleInterface
     */
    public function setLoanId($loanId)
    {
        return $this->setData(self::LOAN_ID, $loanId);
    }

    /**
     * Get message
     * @return string|null
     */
    public function getMessage()
    {
        return $this->_get(self::MESSAGE);
    }

    /**
     * Set message
     * @param string $message
     * @return \Aplazo\AplazoPayment\Api\Data\SaleInterface
     */
    public function setMessage($message)
    {
        return $this->setData(self::MESSAGE, $message);
    }

    /**
     * Get created_at
     * @return string|null
     */
    public function getCreatedAt()
    {
        return $this->_get(self::CREATED_AT);
    }

    /**
     * Set created_at
     * @param string $createdAt
     * @return \Aplazo\AplazoPayment\Api\Data\SaleInterface
     */
    public function setCreatedAt($createdAt)
    {
        return $this->setData(self::CREATED_AT, $createdAt);
    }

    /**
     * Get updated_at
     * @return string|null
     */
    public function getUpdatedAt()
    {
        return $this->_get(self::UPDATED_AT);
    }

    /**
     * Set updated_at
     * @param string $updatedAt
     * @return \Aplazo\AplazoPayment\Api\Data\SaleInterface
     */
    public function setUpdatedAt($updatedAt)
    {
        return $this->setData(self::UPDATED_AT, $updatedAt);
    }
}

