PHP JSON Component
==================

[![Build Status](https://github.com/skolodyazhnyy/json-stream/workflows/CI/badge.svg)](https://github.com/skolodyazhnyy/json-stream/actions?query=workflow%3ACI)

This project is a rewritten fork of few very nice JSON libs for PHP:

- [salsify/jsonstreamingparser](https://github.com/salsify/jsonstreamingparser) - Json Stream Parser
- [rayward/json-stream](https://github.com/rayward/json-stream) - Json Stream Writer


JSON Writer
-----------

There is an example of product catalog export using JSON Writer

```php
$fh = fopen($filename, "w");
$writer = new Writer($fh);

$writer->enter(Writer::TYPE_OBJECT);                // enter root object
    $writer->write("catalog", $catalog['id']);      // write key-value entry
    $writer->enter("items", Writer::TYPE_ARRAY);    // enter items array
        foreach($catalog['products'] as $product) {
            $writer->write(null, array(             // write an array item
                'sku'  => $product['sku'],
                'name' => $product['name']
            ));
        }
    $writer->leave();                               // leave items array
$writer->leave();                                   // leave root object

fclose($fh);
```

**Output**

```json
{"catalog":19,"items":[{"sku":"0001","name":"Product #1"},{"sku":"0002","name":"Product #2"}]}
```


JSON Reader
-----------

Using JSON Reader you can easily read json generated by code above

```php
$fh = fopen($filename, "r");

$reader = new Reader($fh);
$reader->enter(Reader::TYPE_OBJECT);                // enter root object
    $catalog['id'] = $reader->read("catalog");      // read catalog node
    $reader->enter("items", Reader::TYPE_ARRAY);    // enter item array
        while($product = $reader->read()) {         // read product structure
            $catalog['products'][] = $product;
        }
    $reader->leave();                               // leave item node
$reader->leave();                                   // leave root object

fclose($fh);
```
