# Configuration

## Global Configuration

Configuration file `codeception.yml` is generated by `codecept bootstrap` command. It has preconfigured settings you can change.

Here are global options you can change inside configuration:

* `actor: Tester`: changes suffix for Actor classes. This defines a rule to generate new test suites. If you change `Tester` to `Ninja`, and generate new `api` test suite, you will get `ApiNinja` actor class.
* `namespace`: set a namespace for tests. All new tests and support classes will be generated under that namespace. Allows to configure [multiple test setups for one runner](https://codeception.com/docs/08-Customization#Namespaces).
* `include: []`: include additional Codeception configurations for [multiple applications setup](https://codeception.com/docs/08-Customization#Namespaces).
* `paths` directories used by Codeception. Default values are:

```yaml
paths:
    # where the tests stored
    tests: tests

    # directory for fixture data
    data: tests/_data

    # directory for support code
    support: tests/_support

    # directory for output
    output: tests/_output

    # directory for environment configuration
    envs: tests/_envs
```

* `settings`: provide additional options for test runner. They may dramatically change the way Codeception is executed. For instance, take a note of `shuffle` option which allows to randomize tests execution order and `lint` option that toggles parsing a test file (using `php -l`) before loading it.

```yaml
settings:

    # name of bootstrap that will be used
    # each bootstrap file should be
    # inside a suite directory.
    bootstrap: _bootstrap.php

    # enable/disable syntax of test files before loading
    # for php < 7 exec('php -l') is used
    # disable if you need to speed up tests execution
    lint: true

    # randomize test order
    shuffle: true

    # by default it's false on Windows
    # use [ANSICON](https://github.com/adoxa/ansicon) to colorize output.
    colors: true

    # Generate XML JUnit report using strict schema
    # Avoid putting additional report fields like steps or scenario names tot it
    # Required for XML reports on Jenkins CI
    strict_xml: false

    # Tests (especially functional) can take a lot of memory
    # We set a high limit for them by default.
    memory_limit: 1024M

    # This value controls whether PHPUnit attempts to backup global variables
    # See https://phpunit.de/manual/current/en/appendixes.annotations.html#appendixes.annotations.backupGlobals
    backup_globals: true

    # PHPUnit can be strict about tests that do not test anything
    # See https://phpunit.de/manual/current/en/risky-tests.html#risky-tests.useless-tests
    report_useless_tests: false

    # PHPUnit can be strict about output during tests.
    # See https://phpunit.de/manual/current/en/risky-tests.html#risky-tests.output-during-test-execution
    disallow_test_output: false

    # PHPUnit can be strict about tests that manipulate global state.
    # See https://phpunit.de/manual/current/en/risky-tests.html#risky-tests.global-state-manipulation
    be_strict_about_changes_to_global_state: false

    # Log the incomplete and skipped tests into junit report
    # See https://phpunit.de/manual/current/en/appendixes.configuration.html
    # Section logging > junit
    log_incomplete_skipped: false
```

* `modules`: allows to create shared module configuration for all included suites.

```yaml
modules:
    config:
        Db:
            dsn: ''
            user: ''
            password: ''
            dump: tests/_data/dump.sql
```
* `extends`: allows you to specify a file (relative to the `codeception.yml` file) that holds some already pre-defined values. This can be used to always use the same configuration for modules or whatever.
* `extensions`: allows to enable and configure [Codeception extensions](https://codeception.com/docs/08-Customization#Extension), [Group Objects](https://codeception.com/docs/08-Customization#Group-Objects), and [Custom Commands](https://codeception.com/docs/08-Customization#Custom-Commands).
* `reporters`: allows to [change default reporters](https://codeception.com/docs/08-Customization#Custom-Reporters) of Codeception
* `coverage`: [CodeCoverage](https://codeception.com/docs/11-Codecoverage#Configuration) settings.
* `params`: allows to pass [external parameters](https://codeception.com/docs/06-ModulesAndHelpers#Dynamic-Configuration-With-Params) into module configuration.
* `gherkin`: BDD-specific [Gherkin options](https://codeception.com/docs/07-BDD#Configuration).

## Suite Configuration

Each generated suite have its own configuration inside directory set by `paths: tests: ` configuration option in `codeception.yml`. Each suite configuration is named like `suitename.suite.yml`. It allows to enable and configure modules, and more.

* `actor`: name of the actor class for current suite.
* `modules`: list of enabled modules with their configuration.

```yaml
modules:
    # enabled modules and helpers
    enabled:
        # built-in modules are listed by their names
        - PhpBrowser:
            # module configuration
            url: http://localhost
        # this module is pre-configured in global config
        - Db

        # helper names are listed by their class names
        # by convention their names start with \
        - \Helper\Acceptance

    # additional modules configuration
    # can be used for modules which are not currently enabled
    config:
        WebDriver:
            browser: firefox

    # list of modules disabled for this suite
    disabled:
        - WebDriver

```

* `extends`: allows you to specify a file (relative to the `*.suite.yml` file) that holds some already pre-defined values. This can be used to always use the same configuration for modules or whatever.
* `namespace`: default namespace of actor, support classes and tests.
* `suite_namespace`: default namespace for new tests of this suite (ignores `namespace` option)
* `env`: override any configuration per [environment](https://codeception.com/docs/07-AdvancedUsage#Environments).
* `groups`: [groups](https://codeception.com/docs/07-AdvancedUsage#Groups) with the list of tests of for corresponding group.
* `formats`: [formats](https://codeception.com/docs/07-AdvancedUsage#Formats) with the list of extra test format classes.
* `coverage`: pre suite [CodeCoverage](https://codeception.com/docs/11-Codecoverage#Configuration) settings.
* `gherkin`: per suite [BDD Gherkin](https://codeception.com/docs/07-BDD#Configuration) settings.
* `error_level`: [error level](https://codeception.com/docs/04-FunctionalTests#Error-Reporting) for runner in current suite. Should be specified for unit, integration, functional tests. Passes value to `error_reporting` function.

## Config Templates (dist)

To provide the same configuration template for your development team, you can create a `codeception.dist.yml` config file, which will be loaded before `codeception.yml`. The dist config provides shared options, while local `codeception.yml` files override them on a per-installation basis. Therefore, `codeception.yml` should be ignored by your VCS system.

Config templates can also be used for suite configuration, by creating a `suitename.suite.dist.yml` file.

Configuration loading order:

1. `codeception.dist.yml`
2. `codeception.yml`
3. `acceptance.suite.dist.yml`
4. `acceptance.suite.yml`
5. environment config
