<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\DLP;

class GooglePrivacyDlpV2RecordKey extends \Google\Collection
{
  protected $collection_key = 'idValues';
  protected $bigQueryKeyType = GooglePrivacyDlpV2BigQueryKey::class;
  protected $bigQueryKeyDataType = '';
  public $bigQueryKey;
  protected $datastoreKeyType = GooglePrivacyDlpV2DatastoreKey::class;
  protected $datastoreKeyDataType = '';
  public $datastoreKey;
  /**
   * @var string[]
   */
  public $idValues;

  /**
   * @param GooglePrivacyDlpV2BigQueryKey
   */
  public function setBigQueryKey(GooglePrivacyDlpV2BigQueryKey $bigQueryKey)
  {
    $this->bigQueryKey = $bigQueryKey;
  }
  /**
   * @return GooglePrivacyDlpV2BigQueryKey
   */
  public function getBigQueryKey()
  {
    return $this->bigQueryKey;
  }
  /**
   * @param GooglePrivacyDlpV2DatastoreKey
   */
  public function setDatastoreKey(GooglePrivacyDlpV2DatastoreKey $datastoreKey)
  {
    $this->datastoreKey = $datastoreKey;
  }
  /**
   * @return GooglePrivacyDlpV2DatastoreKey
   */
  public function getDatastoreKey()
  {
    return $this->datastoreKey;
  }
  /**
   * @param string[]
   */
  public function setIdValues($idValues)
  {
    $this->idValues = $idValues;
  }
  /**
   * @return string[]
   */
  public function getIdValues()
  {
    return $this->idValues;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GooglePrivacyDlpV2RecordKey::class, 'Google_Service_DLP_GooglePrivacyDlpV2RecordKey');
