<?php


namespace Kueski\Data;


use Kueski\Data\Amount\Details;

class Amount
{

    /**
     * @var float
     */
    private $total = 0.00;

    /**
     * @var string
     */
    private $currency = "MXN";

    /**
     * @var Details
     */
    private $details;

    /**
     * @param float $subtotal
     * @param float $shipping
     * @param float $handlingFee
     * @param float $tax
     */
    public function addDetails( $subtotal, $shipping = 0.00, $handlingFee = 0.00, $tax = 0.00 ) {
        $details = new Details();
        $details->setSubtotal($subtotal);
        $details->setShipping($shipping);
        $details->setHandlingFee($handlingFee);
        $details->setTax($tax);
        $this->details = $details;
    }

    /**
     * @return float
     */
    public function getTotal()
    {
        return $this->total;
    }

    /**
     * @param float $total
     */
    public function setTotal($total)
    {
        $this->total = $total;
    }

    /**
     * @return string
     */
    public function getCurrency()
    {
        return $this->currency;
    }

    /**
     * @param string $currency
     */
    public function setCurrency($currency)
    {
        $this->currency = $currency;
    }

    /**
     * @return Details
     */
    public function getDetails()
    {
        return $this->details;
    }

    /**
     * @param Details $details
     */
    public function setDetails(Details $details)
    {
        $this->details = $details;
    }


}