<?php


namespace Kueski\Data;


class Billing
{
    /**
     * @var string
     */
    private $name;

    /**
     * @var string
     */
    private $rfc;

    /**
     * @var string
     */
    private $address;

    /**
     * @var string
     */
    private $interior;

    /**
     * @var string
     */
    private $neighborhood;

    /**
     * @var string
     */
    private $city;

    /**
     * @var string
     */
    private $state;

    /**
     * @var string
     */
    private $zipcode;

    /**
     * @var string
     */
    private $country;

    /**
     * @var string
     */
    private $phoneNumber;

    /**
     * @var string
     */
    private $email;

    /**
     * @param $name
     * @param $rfc
     * @return Billing
     */
    public function setName($name, $rfc) {
        $this->name = $name;
        $this->rfc = $rfc;
        return $this;
    }

    /**
     * @param $address
     * @param $interior
     * @param $neighborhood
     * @param $city
     * @param $state
     * @param $zipcode
     * @param $country
     * @return Billing
     */
    public function setAddress($address, $interior, $neighborhood, $city, $state, $zipcode, $country) {
        $this->address = $address;
        $this->interior = $interior;
        $this->neighborhood = $neighborhood;
        $this->city = $city;
        $this->state = $state;
        $this->zipcode = $zipcode;
        $this->country = $country;
        return $this;
    }

    /**
     * @param $phoneNumber
     * @param $email
     * @return Billing
     */
    public function setAdditionalInformation($phoneNumber, $email)
    {
        $this->phoneNumber = $phoneNumber;
        $this->email = $email;
        return $this;
    }

    /**
     * @return array
     */
    public function getBusiness() {
        return [
            "name" => $this->name,
            "rfc" => $this->rfc
        ];
    }

    /**
     * @return array
     */
    public function getAddress() {
        return [
            "address" => $this->address,
            "interior" => $this->interior,
            "neighborhood" => $this->neighborhood,
            "city" => $this->city,
            "state" => $this->state,
            "zipcode" => $this->zipcode,
            "country" => $this->country
        ];
    }

    /**
     * @return string
     */
    public function getPhoneNumber() {
        return $this->phoneNumber;
    }

    /**
     * @return string
     */
    public function getEmail() {
        return $this->email;
    }
}