<?php


namespace Kueski\Data;


use Kueski\Data\Metadata\AdditionalService;
use Kueski\Data\Metadata\Contact;
use Kueski\Data\Metadata\Journey;
use Kueski\Data\Metadata\Passenger;

class Metadata
{
    /**
     * @var Contact
     */
    private $contact;

    /**
     * @var Passenger[]
     */
    private $passengers;

    /**
     * @var Journey[]
     */
    private $journeys;

    /**
     * @var AdditionalService[]
     */
    private $additionalServices;

    /**
     * @param string $firstName
     * @param string $middleName
     * @param string $lastName
     * @param string $birthdate
     * @param string $nationality
     * @param string $gender
     * @param string $email
     * @param string $mobile
     * @param string $phone
     */
    public function addNewPassengerData(
        $firstName = "",
        $middleName = "",
        $lastName = "",
        $birthdate = "",
        $nationality = "",
        $gender = "",
        $email = "",
        $mobile = "",
        $phone = ""
    ) {
        $passenger = new Passenger($firstName, $middleName, $lastName, $birthdate, $nationality, $gender, $email, $mobile, $phone);
        $this->addNewPassenger($passenger);
    }

    /**
     * @param Passenger $passenger
     */
    public function addNewPassenger(Passenger $passenger) {
        $this->passengers[] = $passenger;
    }

    /**
     * @param string $carrierCode
     * @param string $flightNumber
     * @param string $departureStation
     * @param string $departureTime
     * @param string $arrivalStation
     * @param string $arrivalTime
     */
    public function addNewJourneyData(
        $carrierCode = "",
        $flightNumber = "",
        $departureStation = "",
        $departureTime = "",
        $arrivalStation = "",
        $arrivalTime = ""
    ) {
        $journey = new Journey($carrierCode, $flightNumber, $departureStation, $departureTime, $arrivalStation, $arrivalTime);
        $this->addNewJourney($journey);
    }

    /**
     * @param Journey $journey
     */
    public function addNewJourney(Journey $journey) {
        $this->journeys[] = $journey;
    }

    /**
     * @param string $serviceCode
     * @param string $description
     */
    public function addNewAdditionalServiceData($serviceCode = "", $description = "") {
        $additionalService = new AdditionalService($serviceCode, $description);
        $this->addNewAdditionalServiceData($additionalService);
    }

    /**
     * @param AdditionalService $additionalService
     */
    public function addNewAdditionalService(AdditionalService $additionalService) {
        $this->additionalServices[] = $additionalService;
    }

    /**
     * @param $name
     * @param $email
     * @param $mobile
     * @param $phone
     * @param $postalCode
     */
    public function setContact($name, $email, $mobile, $phone, $postalCode) {
        $this->contact = new Contact($name, $email, $mobile, $phone, $postalCode);
    }


    /**
     * @return Contact
     */
    public function getContact()
    {
        return $this->contact;
    }

    /**
     * @return Passenger[]
     */
    public function getPassengers()
    {
        return $this->passengers;
    }

    /**
     * @return Journey[]
     */
    public function getJourneys()
    {
        return $this->journeys;
    }

    /**
     * @return AdditionalService[]
     */
    public function getAdditionalServices()
    {
        return $this->additionalServices;
    }





}