<?php


namespace Kueski\Data;


class Shipping
{
    /**
     * @var string
     */
    private $name;

    /**
     * @var string
     */
    private $lastname;

    /**
     * @var string
     */
    private $address;

    /**
     * @var string
     */
    private $interior;

    /**
     * @var string
     */
    private $neighborhood;

    /**
     * @var string
     */
    private $city;

    /**
     * @var string
     */
    private $state;

    /**
     * @var string
     */
    private $zipcode;

    /**
     * @var string
     */
    private $country;

    /**
     * @var string
     */
    private $phoneNumber;

    /**
     * @var string
     */
    private $email;

    /**
     * @var string
     */
    private $type;

    /**
     * @param $name
     * @param $lastname
     * @return Shipping
     */
    public function setName($name, $lastname) {
        $this->name = $name;
        $this->lastname = $lastname;
        return $this;
    }

    /**
     * @param $address
     * @param $interior
     * @param $neighborhood
     * @param $city
     * @param $state
     * @param $zipcode
     * @param $country
     * @return Shipping
     */
    public function setAddress($address, $interior, $neighborhood, $city, $state, $zipcode, $country) {
        $this->address = $address;
        $this->interior = $interior;
        $this->neighborhood = $neighborhood;
        $this->city = $city;
        $this->state = $state;
        $this->zipcode = $zipcode;
        $this->country = $country;
        return $this;
    }

    /**
     * @param $phoneNumber
     * @param $email
     * @param $type
     * @return Shipping
     */
    public function setAdditionalInformation($phoneNumber, $email, $type)
    {
        $this->phoneNumber = $phoneNumber;
        $this->email = $email;
        $this->type = $type;
        return $this;
    }

    /**
     * @return array
     */
    public function getName() {
        return [
            "name" => $this->name,
            "last" => $this->lastname
        ];
    }

    /**
     * @return array
     */
    public function getAddress() {
        return [
            "address" => $this->address,
            "interior" => $this->interior,
            "neighborhood" => $this->neighborhood,
            "city" => $this->city,
            "state" => $this->state,
            "zipcode" => $this->zipcode,
            "country" => $this->country
        ];
    }

    /**
     * @return string
     */
    public function getPhoneNumber() {
        return $this->phoneNumber;
    }

    /**
     * @return string
     */
    public function getEmail() {
        return $this->email;
    }

    /**
     * @return string
     */
    public function getType() {
        return $this->type;
    }
}