<?php

namespace Kueski\Payment\Block\Checkout\Cart;

use Kueski\Payment\Helper\Widget as WidgetHelper;
use Kueski\Payment\Helper\Data as HelperData;
use Kueski\Payment\Model\Config as ConfigModel;

class Widget extends \Magento\Checkout\Block\Cart\AbstractCart
{
    /**
     * @var \Kueski\Payment\Helper\Widget
     */
    protected $_widgetheper;
    /**
     * @var \Kueski\Payment\Helper\Data
     */
    protected $_helperData;
    /**
     * @var ConfigModel
     */
    protected $_configModel;

    /**
     * @param \Magento\Framework\View\Element\Template\Context $context
     * @param \Magento\Customer\Model\Session $customerSession
     * @param \Magento\Checkout\Model\Session $checkoutSession
     * @param \Magento\Framework\App\ProductMetadataInterface $productMetadata
     * @param WidgetHelper $widgetheper
     * @param HelperData $helperData
     * @param ConfigModel $configModel
     * @param array $data
     */
    public function __construct
    (
        \Magento\Framework\View\Element\Template\Context $context,
        \Magento\Customer\Model\Session $customerSession,
        \Magento\Checkout\Model\Session $checkoutSession,
        \Magento\Framework\App\ProductMetadataInterface $productMetadata,
        WidgetHelper $widgetheper,
        HelperData $helperData,
        ConfigModel $configModel,
        array $data = []
    ) {
        parent::__construct($context, $customerSession, $checkoutSession, $data);
        $this->_productMetadata     = $productMetadata;
        $this->_widgetheper         = $widgetheper;
        $this->_helperData          = $helperData;
        $this->_configModel         = $configModel;
    }

    public function getHelperWidget(){
        return $this->_widgetheper;
    }

    public function getHelperData(){
        return $this->_helperData;
    }

    public function getKpVersion()
    {
        return $this->_productMetadata->getVersion();
    }

    public function getApiKey()
    {
        return $this->_configModel->getConfig(ConfigModel::XML_API_KEY);
    }

}
