<?php


namespace Kueski\Payment\Block;


use Detection\MobileDetect;
use Magento\Checkout\Model\Session;
use Magento\Framework\View\Element\Template;
use Magento\Sales\Model\Order;

class Kueski extends Template
{
    /**
     * @var Session
     */
    protected $_checkoutSession;
    /**
     * @var Order
     */
    protected $_order;

    /**
     * Kueski constructor.
     * @param Session $checkoutSession
     * @param Template\Context $context
     * @param array $data
     */
    public function __construct(
        Session $checkoutSession,
        Template\Context $context,
        array $data = array()
    ) {
        parent::__construct($context, $data);
        $this->_checkoutSession = $checkoutSession;
    }

    /**
     * @return Order
     */
    public function getOrder()
    {
        if (!$this->_order) {
            $this->_order = $this->_checkoutSession->getLastRealOrder();
        }
        return $this->_order;
    }

    /**
     * @param $path
     * @return mixed
     */
    public function getStoreConfig($path)
    {
        return $this->_scopeConfig->getValue($path);
    }

    /**
     * @param $path
     * @return bool
     */
    public function getStoreConfigFlag($path)
    {
        return $this->_scopeConfig->isSetFlag($path);
    }

    /**
     * @return bool
     */
    public function isMobile()
    {
        $detect = new MobileDetect();

        return $detect->isMobile();
    }
}
