<?php

namespace Kueski\Payment\Block\Product\View;

use Magento\Catalog\Api\ProductRepositoryInterface;
use Magento\Catalog\Block\Product\AbstractProduct;
use Magento\Framework\View\Element\Template;
use Magento\Store\Model\ScopeInterface;
use Magento\Catalog\Block\Product\Context;

class Widget extends \Magento\Framework\View\Element\Template
{
    /**
     * @var \Magento\Catalog\Block\Product\Context
     */
    protected $_context;
    /**
     * @var \Magento\Framework\App\ProductMetadataInterface
     */
    protected $_productMetadata;
    /**
     * @var \Kueski\Payment\Helper\Widget
     */
    protected $_widgetheper;
    /**
     * @var \Kueski\Payment\Helper\Data
     */
    protected $_helperData;
    /**
     * @var \Magento\Framework\Registry
     */
    protected $_registry;

    public function __construct(
        Template\Context $context,
        \Magento\Framework\Registry $registry,
        \Kueski\Payment\Helper\Widget $widgetheper,
        \Kueski\Payment\Helper\Data $helperData,
        array $data = []
    )
    {
        $this->_widgetheper = $widgetheper;
        $this->_helperData = $helperData;
        $this->_registry = $registry;
        parent::__construct($context, $data);
    }


    public function _prepareLayout()
    {
        return parent::_prepareLayout();
    }

    public function getCurrentProduct()
    {
        return $this->_registry->registry('current_product');
    }

    public function getHelperWidget()
    {
        return $this->_widgetheper;
    }

    public function getHelperData()
    {
        return $this->_helperData;
    }

}
