<?php
namespace Kueski\Payment\Controller;

use Magento\Framework\App\Action\Context;

abstract class AbstractResult extends \Magento\Framework\App\Action\Action
{
    /**
     * @var \Magento\Framework\View\Result\PageFactory
     */
    protected $_resultPageFactory;
    /**
     * @var \Magento\Framework\Controller\ResultFactory
     */
    protected $_resultFactory;
    /**
     * @var \Magento\Checkout\Model\Session
     */
    protected $_checkoutSession;

    /**
     * @param \Magento\Framework\Controller\ResultFactory $resultFactory
     * @param \Magento\Framework\View\Result\PageFactory $resultPageFactory
     * @param \Magento\Checkout\Model\Session $checkoutSession
     * @param Context $context
     */
    public function __construct(
        \Magento\Framework\Controller\ResultFactory $resultFactory,
        \Magento\Framework\View\Result\PageFactory $resultPageFactory,
        \Magento\Checkout\Model\Session $checkoutSession,
        Context $context
    ) {
        parent::__construct($context);
        $this->_resultFactory = $resultFactory;
        $this->_resultPageFactory = $resultPageFactory;
        $this->_checkoutSession = $checkoutSession;
    }

    abstract function execute();

    /**
     * @return bool
     */
    public function allowDisplay()
    {
        $result = true;

        if (!$this->_checkoutSession->getLastSuccessQuoteId()) {
            $result =  false;
        }

        if (!$this->_checkoutSession->getLastQuoteId() || !$this->_checkoutSession->getLastOrderId()) {
            $result =  false;
        }

        //        always clear quote
        $this->_checkoutSession->clearQuote();
        return $result;

    }
}
