<?php
namespace Kueski\Payment\Controller\Gateway;

use Kueski\Payment\Exceptions\KueskiException;
use Magento\Checkout\Model\Session;
use Magento\Framework\App\ActionInterface;
use Kueski\Payment\Model\Payment\Kueski as Payment;
use Magento\Framework\Controller\Result\JsonFactory;
use Magento\Framework\Controller\ResultFactory;
use Magento\Framework\Message\ManagerInterface;
use Magento\Framework\App\Response\RedirectInterface;

class Redirector implements ActionInterface
{
    /**
     * @var Payment
     */
    private $payment;
    /**
     * @var Session
     */
    protected $_checkoutSession;
    /**
     * @var JsonFactory
     */
    protected $_jsonFactory;
    /**
     * @var ResultFactory
     */
    protected $_resultRedirect;
    /**
     * @var ManagerInterface
     */
    protected $_messageManager;
    /**
     * @var RedirectInterface
     */
    protected $_redirect;

    public function __construct(
        Payment $payment,
        Session $checkoutSession,
        JsonFactory $jsonFactory,
        ResultFactory $result,
        ManagerInterface $messageManager,
        RedirectInterface $redirect
    ) {
        $this->payment          = $payment;
        $this->_checkoutSession = $checkoutSession;
        $this->_jsonFactory     = $jsonFactory;
        $this->_resultRedirect  = $result;
        $this->_messageManager = $messageManager;
        $this->_redirect        = $redirect;
    }

    /**
     * @return \Magento\Framework\App\ResponseInterface|\Magento\Framework\Controller\Result\Json|\Magento\Framework\Controller\ResultInterface
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    public function execute()
    {
        $redirect = '';

        /* @var \Magento\Sales\Model\Order $order */
        $order = $this->_checkoutSession->getLastRealOrder();

        try {
            if (!$order->getId()) {
                throw new KueskiException(__('Not found order to send to Kueski'));
            }

            $payment = $order->getPayment()->getMethodInstance();
            $redirect = $payment->redirectGateway();

            if (!$redirect) {
                throw new KueskiException(__('Failure to send to Kueski gateway'));
            }

            $redirect = $this->_jsonFactory->create()
                ->setData([
                    'gateway' => $redirect
                ]);
        } catch (KueskiException $e) {
            $this->_messageManager->addErrorMessage($e->getMessage());

            return $this->_resultRedirect->create(ResultFactory::TYPE_REDIRECT)
                ->setUrl($this->_redirect->getRefererUrl());
        }

        return $redirect;
    }
}
