<?php
namespace Kueski\Payment\Controller;

use Kueski\Payment\Exceptions\KueskiException;
use Kueski\Payment\Helper\Order as OrderHelper;
use Magento\Checkout\Model\Session;
use Magento\Framework\Message\ManagerInterface;
use Magento\Framework\App\RequestInterface;
use Magento\Sales\Model\OrderRepository;
use Magento\Framework\Api\SearchCriteriaBuilder;

class Onepage
{
    /**
     * @var Session
     */
    protected $_session;
    /**
     * @var ManagerInterface
     */
    protected $_manager;
    /**
     * @var RequestInterface
     */
    protected $_request;
    /**
     * @var OrderHelper
     */
    protected $_orderHelper;

    /**
     * @param OrderHelper $orderHelper
     * @param RequestInterface $request
     * @param ManagerInterface $manager
     * @param Session $session
     */
    public function __construct(
        OrderHelper $orderHelper,
        RequestInterface $request,
        ManagerInterface $manager,
        Session $session
    ) {
        $this->_orderHelper = $orderHelper;
        $this->_request = $request;
        $this->_manager = $manager;
        $this->_session = $session;
    }

    /**
     * @param $orderId
     * @return bool
     */
    public function validate($orderId)
    {
        try {
            if (!$this->_session->getLastOrderId()) {
                throw new KueskiException(__('Impossible to retrieve Order ID'));
            }

            $order = $this->_orderHelper->getOrder($orderId);

            if ($order->getId() !== $this->_session->getLastOrderId()) {
                throw new KueskiException(__('Impossible to retrieve Order ID'));
            }
        } catch (KueskiException $e) {
            $this->_manager->addError($e->getMessage());
            return false;
        }

        $this->_session->unsLastOrderId();
        return $order;
    }
}
