<?php
namespace Kueski\Payment\Controller\Onepage;

use Kueski\Payment\Controller\Onepage as OnepageController;
use Kueski\Payment\Helper\Order as OrderHelper;
use Magento\Framework\App\RequestInterface;
use Magento\Checkout\Model\Session;
use Magento\Framework\Exception\LocalizedException;
use Magento\Framework\Message\ManagerInterface;
use Magento\Framework\Controller\ResultInterface;
use Magento\Framework\View\Result\PageFactory;
use Magento\Framework\Controller\Result\RedirectFactory;
use Magento\Sales\Model\OrderRepository;
use Magento\Framework\Api\SearchCriteriaBuilder;
use Magento\Checkout\Model\Session\SuccessValidator;


class Success extends OnepageController implements \Magento\Framework\App\Action\HttpGetActionInterface
{
    /**
     * @var PageFactory
     */
    private $result;
    /**
     * @var RedirectFactory
     */
    private $redirect;

    /**
     * @param PageFactory $result
     * @param RedirectFactory $redirect
     * @param OrderHelper $orderHelper
     * @param RequestInterface $request
     * @param ManagerInterface $manager
     * @param Session $session
     */
    public function __construct(
        PageFactory $result,
        RedirectFactory $redirect,
        OrderHelper $orderHelper,
        RequestInterface $request,
        ManagerInterface $manager,
        Session $session
    ) {
        parent::__construct(
            $orderHelper,
            $request,
            $manager,
            $session
        );

        $this->redirect = $redirect;
        $this->result = $result;
    }

    /**
     * @return Redirect|ResultInterface
     */
    public function execute()
    {
        $orderId = $this->_request->getParam('id');
        $validation = $this->validate($orderId);
        if (!$orderId || !$validation) {
            return $this->redirect->create()
                ->setPath("/");
        }

        $order = $validation;
        $result = $this->result->create();

        /** @var \Kueski\Payment\Block\Onepage\Success $block */
        $block = $result->getLayout()->getBlock('onepage.success');

        try {
            $block->setOrderId($orderId)
                ->setOrder($order);
        } catch (LocalizedException $e) {
            $this->_manager->addWarningMessage(__('Kueski success - success page not available'));

            $result = $this->redirect->create()
                ->setPath('/');
        } catch (\Exception $e) {
            $this->_manager->addWarningMessage(__('Kueski success - success page not available'));
            $result = $this->redirect->create()
                ->setPath('/');
        }

        return $result;
    }
}
