<?php
namespace Kueski\Payment\Controller\Reject;

use Exception;
use Magento\Froamework\App\ResponseInterface;
use Kueski\Payment\Controller\Reconciliation as ReconciliationController;
use Kueski\Payment\Controller\AbstractResult;

class Index extends AbstractResult implements \Magento\Framework\App\Action\HttpPostActionInterface
{
    /**
     * Execute action based on request and return result
     *
     * Note: Request will be added as operation argument in future
     *
     * @return ResponseInterface
     * @throws Exception
     */
    public function execute()
    {
        $result = $this->_resultPageFactory->create();

        if (!$this->allowDisplay()) {
            $result = $this->resultFactory->create(\Magento\Framework\Controller\ResultFactory::TYPE_REDIRECT);
            $result->setUrl('/');

            return $result;
        }

        $order = $this->_checkoutSession->getLastRealOrder();

        /** @var \Magento\Checkout\Block\Onepage\Failure $block */
        $block = $result->getLayout()->getBlock('checkout.failure');
        $block->setData('order', $order);

        return $result;
    }
}
