<?php
namespace Kueski\Payment\Exceptions\Kueski;

use Magento\Framework\Api\AttributeValueFactory;
use Magento\Framework\App\ObjectManager;
use Magento\Framework\Exception\LocalizedException;
use Magento\Framework\Phrase;

class ReconciliationException extends \Exception
{
    /**
     * @var Psr\Log\LoggerInterface
     */
    protected $_logger;

    public function __construct(
        $message = "",
        $code = 0,
        \Throwable $previous = null
    )
    {
        parent::__construct($message, $code, $previous);
        $this->logging($message);
    }

    protected function logging($phrase)
    {
        $logger = $this->getLoggerInstance();
        $logger->critical('KUESKI: ' . $phrase);
    }

    private function getLoggerInstance()
    {
        return ObjectManager::getInstance()->get(\Psr\Log\LoggerInterface::class);
    }
}
