<?php

namespace Kueski\Payment\Helper;

use Kueski\Kueski as KueskiLib;
use Kueski\Payment\Model\Config as ConfigModel;
use Kueski\Payment\Exceptions\KueskiException;
use Magento\Framework\App\Helper\Context;
use Magento\Sales\Model\Order\Payment;
use Magento\Store\Model\ScopeInterface;
use \Magento\Framework\App\Helper\AbstractHelper;


class Data extends AbstractHelper
{
    /**
     * @var \Magento\Framework\App\Config\ScopeConfigInterface
     */
    protected $_scopeConfig;
    /**
     * @var \Kueski\Payment\Logger\Logger
     */
    protected $_kueskiLog;
    /**
     * @var \Magento\Framework\App\ProductMetadataInterface
     */
    protected $_productMetadata;
    /**
     * @var ConfigModel
     */
    protected $_configModel;

    /**
     * @param Context $context
     * @param \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig
     * @param \Magento\Framework\App\ProductMetadataInterface $productMetadata
     * @param \Kueski\Payment\Logger\Logger $kueskiLog
     */
    public function __construct(
        ConfigModel $configModel,
        Context $context,
        \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig,
        \Magento\Framework\App\ProductMetadataInterface $productMetadata,
        \Kueski\Payment\Logger\Logger $kueskiLog
    ) {
        parent::__construct($context);
        $this->_scopeConfig = $scopeConfig;
        $this->_kueskiLog = $kueskiLog;
        $this->_productMetadata = $productMetadata;
        $this->_configModel = $configModel;
    }

    public function isSandbox()
    {
        return $this->_configModel->isSandBox();
    }

    /**
     * @return string
     */
    public function getUrl() {
        if ($this->isSandbox()) {
            return KueskiLib::URL_SANDBOX;
        } else {
            return KueskiLib::URL_PRODUCTION;
        }
    }

    public function getKpName()
    {
        $this->_kueskiLog->debug(var_export("getKpName", true));
        $this->_kueskiLog->debug(var_export($this->_productMetadata->getName(), true));
        $this->_kueskiLog->debug(var_export($this->_productMetadata->getVersion(), true));
        $this->_kueskiLog->debug(var_export($this->_productMetadata->getEdition(), true));
        switch ($this->_productMetadata->getEdition()) {
            case "B2B":
            {
                $kpName = "magento_" . $this->_productMetadata->getVersion() . "_cloud";
                break;
            }
            case "Enterprise":
            {
                $kpName = "magento_" . $this->_productMetadata->getVersion() . "_onpremise";
                break;
            }
            default:
            {
                $kpName = "magento_" . $this->_productMetadata->getVersion() . "_commerce";
                break;
            }
        }

        $this->_kueskiLog->debug($kpName);
        return $kpName;
    }
}
